/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.InputStream;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;

public final class RAMDirectory
extends Directory {
    Hashtable files = new Hashtable();

    public RAMDirectory() {
    }

    public RAMDirectory(Directory dir) throws IOException {
        this(dir, false);
    }

    private RAMDirectory(Directory dir, boolean closeDir) throws IOException {
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            OutputStream os = this.createFile(files[i]);
            InputStream is = dir.openFile(files[i]);
            int len = (int)is.length();
            byte[] buf = new byte[len];
            is.readBytes(buf, 0, len);
            os.writeBytes(buf, len);
            is.close();
            os.close();
        }
        if (closeDir) {
            dir.close();
        }
    }

    public RAMDirectory(File dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public RAMDirectory(String dir) throws IOException {
        this(FSDirectory.getDirectory(dir, false), true);
    }

    public final String[] list() {
        String[] result = new String[this.files.size()];
        int i = 0;
        Enumeration names = this.files.keys();
        while (names.hasMoreElements()) {
            result[i++] = (String)names.nextElement();
        }
        return result;
    }

    public final boolean fileExists(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file != null;
    }

    public final long fileModified(String name) throws IOException {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.lastModified;
    }

    public void touchFile(String name) throws IOException {
        long ts2;
        RAMFile file = (RAMFile)this.files.get(name);
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        file.lastModified = ts2;
    }

    public final long fileLength(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return file.length;
    }

    public final void deleteFile(String name) {
        this.files.remove(name);
    }

    public final void renameFile(String from, String to) {
        RAMFile file = (RAMFile)this.files.get(from);
        this.files.remove(from);
        this.files.put(to, file);
    }

    public final OutputStream createFile(String name) {
        RAMFile file = new RAMFile();
        this.files.put(name, file);
        return new RAMOutputStream(file);
    }

    public final InputStream openFile(String name) {
        RAMFile file = (RAMFile)this.files.get(name);
        return new RAMInputStream(file);
    }

    public final Lock makeLock(final String name) {
        return new Lock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean obtain() throws IOException {
                Hashtable hashtable = RAMDirectory.this.files;
                synchronized (hashtable) {
                    if (!RAMDirectory.this.fileExists(name)) {
                        RAMDirectory.this.createFile(name).close();
                        return true;
                    }
                    return false;
                }
            }

            public void release() {
                RAMDirectory.this.deleteFile(name);
            }

            public boolean isLocked() {
                return RAMDirectory.this.fileExists(name);
            }
        };
    }

    public final void close() {
    }
}

