/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.formula.ArgumentSeparator;
import jxl.biff.formula.Attribute;
import jxl.biff.formula.BuiltInFunction;
import jxl.biff.formula.CloseParentheses;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.NameTable;
import jxl.biff.formula.OpenParentheses;
import jxl.biff.formula.Operand;
import jxl.biff.formula.Operator;
import jxl.biff.formula.Parenthesis;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFunction;
import jxl.biff.formula.StringOperator;
import jxl.biff.formula.VariableArgFunction;
import jxl.biff.formula.Yylex;

class StringFormulaParser
implements Parser {
    private String formula;
    private String parsedFormula;
    private ParseItem root;
    private Stack arguments;
    private WorkbookSettings settings;
    private ExternalSheet externalSheet;
    private NameTable nameTable;

    public StringFormulaParser(String f, ExternalSheet es, NameTable nt, WorkbookSettings ws) {
        this.formula = f;
        this.settings = ws;
        this.externalSheet = es;
        this.nameTable = nt;
    }

    public void parse() throws FormulaException {
        ArrayList tokens = this.getTokens();
        Iterator i = tokens.iterator();
        this.root = this.parseCurrent(i);
    }

    private ParseItem parseCurrent(Iterator i) throws FormulaException {
        ParseItem rt;
        Stack<ParseItem> stack = new Stack<ParseItem>();
        Stack<Operator> operators = new Stack<Operator>();
        Stack<ParseItem> args = null;
        boolean parenthesesClosed = false;
        ParseItem lastParseItem = null;
        while (i.hasNext() && !parenthesesClosed) {
            ParseItem pi = (ParseItem)i.next();
            if (pi instanceof Operand) {
                stack.push(pi);
            } else if (pi instanceof StringFunction) {
                this.handleFunction((StringFunction)pi, i, stack);
            } else if (pi instanceof Operator) {
                Operator op = (Operator)pi;
                if (op instanceof StringOperator) {
                    StringOperator sop = (StringOperator)op;
                    op = stack.isEmpty() || lastParseItem instanceof Operator ? sop.getUnaryOperator() : sop.getBinaryOperator();
                }
                if (operators.empty()) {
                    operators.push(op);
                } else {
                    Operator operator = (Operator)operators.peek();
                    if (op.getPrecedence() < operator.getPrecedence()) {
                        operators.push(op);
                    } else {
                        operators.pop();
                        operator.getOperands(stack);
                        stack.push(operator);
                        operators.push(op);
                    }
                }
            } else if (pi instanceof ArgumentSeparator) {
                while (!operators.isEmpty()) {
                    Operator o = (Operator)operators.pop();
                    o.getOperands(stack);
                    stack.push(o);
                }
                if (args == null) {
                    args = new Stack<ParseItem>();
                }
                args.push((ParseItem)stack.pop());
                stack.clear();
            } else if (pi instanceof OpenParentheses) {
                ParseItem pi2 = this.parseCurrent(i);
                Parenthesis p = new Parenthesis();
                pi2.setParent(p);
                p.add(pi2);
                stack.push(p);
            } else if (pi instanceof CloseParentheses) {
                parenthesesClosed = true;
            }
            lastParseItem = pi;
        }
        while (!operators.isEmpty()) {
            Operator o = (Operator)operators.pop();
            o.getOperands(stack);
            stack.push(o);
        }
        ParseItem parseItem = rt = !stack.empty() ? (ParseItem)stack.pop() : null;
        if (args != null && rt != null) {
            args.push(rt);
        }
        this.arguments = args;
        if (!(stack.empty() && operators.empty() || this.settings.getSuppressWarnings())) {
            System.err.println("Warning:  formula " + this.formula + " has a non-empty parse stack");
        }
        return rt;
    }

    private ArrayList getTokens() throws FormulaException {
        ArrayList<ParseItem> tokens = new ArrayList<ParseItem>();
        StringReader sr = new StringReader(this.formula);
        Yylex lex = new Yylex(sr);
        lex.setExternalSheet(this.externalSheet);
        lex.setNameTable(this.nameTable);
        try {
            ParseItem pi = lex.yylex();
            while (pi != null) {
                tokens.add(pi);
                pi = lex.yylex();
            }
        }
        catch (IOException e) {
            if (!this.settings.getSuppressWarnings()) {
                System.err.println(e.toString());
            }
        }
        catch (Error e) {
            throw new FormulaException(FormulaException.lexicalError, this.formula + " at char  " + lex.getPos());
        }
        return tokens;
    }

    public String getFormula() {
        if (this.parsedFormula == null) {
            StringBuffer sb = new StringBuffer();
            this.root.getString(sb);
            this.parsedFormula = sb.toString();
        }
        return this.parsedFormula;
    }

    public byte[] getBytes() {
        return this.root.getBytes();
    }

    private void handleFunction(StringFunction sf, Iterator i, Stack stack) throws FormulaException {
        ParseItem pi2 = this.parseCurrent(i);
        if (sf.getFunction(this.settings) == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.unrecognizedFunction);
        }
        if (sf.getFunction(this.settings) == Function.SUM && this.arguments == null) {
            Attribute a = new Attribute(sf, this.settings);
            a.add(pi2);
            stack.push(a);
            return;
        }
        if (sf.getFunction(this.settings) == Function.IF) {
            Attribute a = new Attribute(sf, this.settings);
            VariableArgFunction vaf = new VariableArgFunction(this.settings);
            int numargs = this.arguments.size();
            for (int j = 0; j < numargs; ++j) {
                ParseItem pi3 = (ParseItem)this.arguments.get(j);
                vaf.add(pi3);
            }
            a.setIfConditions(vaf);
            stack.push(a);
            return;
        }
        if (sf.getFunction(this.settings).getNumArgs() == 255) {
            if (this.arguments == null) {
                VariableArgFunction vaf = new VariableArgFunction(sf.getFunction(this.settings), 1, this.settings);
                vaf.add(pi2);
                stack.push(vaf);
            } else {
                int numargs = this.arguments.size();
                VariableArgFunction vaf = new VariableArgFunction(sf.getFunction(this.settings), numargs, this.settings);
                for (int j = 0; j < numargs; ++j) {
                    ParseItem pi3 = (ParseItem)this.arguments.pop();
                    vaf.add(pi3);
                }
                stack.push(vaf);
                this.arguments.clear();
                this.arguments = null;
            }
            return;
        }
        BuiltInFunction bif = new BuiltInFunction(sf.getFunction(this.settings), this.settings);
        int numargs = sf.getFunction(this.settings).getNumArgs();
        if (numargs == 1) {
            bif.add(pi2);
        } else {
            if (this.arguments == null && numargs != 0 || this.arguments != null && numargs != this.arguments.size()) {
                throw new FormulaException(FormulaException.incorrectArguments);
            }
            for (int j = 0; j < numargs; ++j) {
                ParseItem pi3 = (ParseItem)this.arguments.get(j);
                bif.add(pi3);
            }
        }
        stack.push(bif);
    }

    public void adjustRelativeCellReferences(int colAdjust, int rowAdjust) {
        System.out.println("Adjusting string formula parser");
        this.root.adjustRelativeCellReferences(colAdjust, rowAdjust);
    }
}

