/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.NumberFormat;
import jxl.CellType;
import jxl.DateCell;
import jxl.NumberFormulaCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.biff.formula.NameTable;
import jxl.read.biff.DateRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.SheetImpl;

class DateFormulaRecord
extends DateRecord
implements DateCell,
FormulaData,
NumberFormulaCell {
    private double value;
    private String formulaString;
    private ExternalSheet externalSheet;
    private NameTable nameTable;
    private byte[] data;

    public DateFormulaRecord(NumberFormulaRecord t, FormattingRecords fr, ExternalSheet es, NameTable nt, boolean nf, SheetImpl si) {
        super(t, t.getXFIndex(), fr, nf, si);
        this.externalSheet = es;
        this.nameTable = nt;
        this.data = t.getFormulaData();
    }

    public CellType getType() {
        return CellType.NUMBER_FORMULA;
    }

    public byte[] getFormulaData() {
        return this.data;
    }

    public String getFormula() throws FormulaException {
        if (this.formulaString == null) {
            byte[] tokens = new byte[this.data.length - 16];
            System.arraycopy(this.data, 16, tokens, 0, tokens.length);
            FormulaParser fp = new FormulaParser(tokens, this, this.externalSheet, this.nameTable, this.getSheet().getWorkbook().getSettings());
            fp.parse();
            this.formulaString = fp.getFormula();
        }
        return this.formulaString;
    }

    public double getValue() {
        return this.value;
    }

    public NumberFormat getNumberFormat() {
        return null;
    }
}

