/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.Cell;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.write.WritableCell;
import jxl.write.WritableWorkbook;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;
import jxl.write.biff.WritableWorkbookImpl;

public abstract class CellValue
extends WritableRecordData
implements WritableCell {
    private int row;
    private int column;
    private XFRecord format;
    private FormattingRecords formattingRecords;
    private boolean referenced;
    private WritableSheetImpl sheet;

    protected CellValue(Type t, int c, int r) {
        this(t, c, r, WritableWorkbookImpl.NORMAL_STYLE);
    }

    protected CellValue(Type t, Cell c) {
        this(t, c.getColumn(), c.getRow());
        this.format = (XFRecord)c.getCellFormat();
    }

    protected CellValue(Type t, int c, int r, CellFormat st) {
        super(t);
        this.row = r;
        this.column = c;
        this.format = (XFRecord)st;
        this.referenced = false;
    }

    protected CellValue(Type t, int c, int r, CellValue cv) {
        super(t);
        this.row = r;
        this.column = c;
        this.format = cv.format;
        this.referenced = false;
    }

    public void setCellFormat(CellFormat cf) {
        this.format = (XFRecord)cf;
        if (!this.referenced) {
            return;
        }
        Assert.verify(this.formattingRecords != null);
        try {
            if (!this.format.isInitialized()) {
                this.formattingRecords.addStyle(this.format);
            }
        }
        catch (NumFormatRecordsException e) {
            System.err.println("Warning:  maximum number of format records exceeded.  Using default format");
            this.format = WritableWorkbook.NORMAL_STYLE;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isHidden() {
        ColumnInfoRecord cir = this.sheet.getColumnInfo(this.column);
        if (cir != null && cir.getWidth() == 0) {
            return true;
        }
        RowRecord rr = this.sheet.getRowInfo(this.row);
        return rr != null && (rr.getRowHeight() == 0 || rr.isCollapsed());
    }

    public byte[] getData() {
        byte[] mydata = new byte[6];
        IntegerHelper.getTwoBytes(this.row, mydata, 0);
        IntegerHelper.getTwoBytes(this.column, mydata, 2);
        IntegerHelper.getTwoBytes(this.format.getXFIndex(), mydata, 4);
        return mydata;
    }

    void setCellDetails(FormattingRecords fr, SharedStrings ss, WritableSheetImpl s) {
        this.referenced = true;
        this.sheet = s;
        try {
            if (!this.format.isInitialized()) {
                fr.addStyle(this.format);
            }
            this.formattingRecords = fr;
        }
        catch (NumFormatRecordsException e) {
            System.err.println("Warning:  maximum number of format records exceeded.  Using default format");
            this.format = WritableWorkbook.NORMAL_STYLE;
        }
    }

    final boolean isReferenced() {
        return this.referenced;
    }

    final int getXFIndex() {
        return this.format.getXFIndex();
    }

    public CellFormat getCellFormat() {
        return this.format;
    }

    void incrementRow() {
        ++this.row;
    }

    void decrementRow() {
        --this.row;
    }

    void incrementColumn() {
        ++this.column;
    }

    void decrementColumn() {
        --this.column;
    }
}

