/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.CellType;
import jxl.biff.FormulaData;
import jxl.biff.Type;
import jxl.biff.formula.FormulaException;
import jxl.write.WritableCell;
import jxl.write.biff.CellValue;
import jxl.write.biff.FormulaRecord;

class ReadFormulaRecord
extends CellValue
implements FormulaData {
    private FormulaData formula;

    public ReadFormulaRecord(FormulaData f) {
        super(Type.FORMULA, f);
        this.formula = f;
    }

    public byte[] getData() {
        try {
            byte[] celldata = super.getData();
            byte[] expressiondata = this.formula.getFormulaData();
            expressiondata[8] = (byte)(expressiondata[8] | 2);
            byte[] data = new byte[celldata.length + expressiondata.length];
            System.arraycopy(celldata, 0, data, 0, celldata.length);
            System.arraycopy(expressiondata, 0, data, celldata.length, expressiondata.length);
            return data;
        }
        catch (FormulaException e) {
            Assert.verify(false);
            return new byte[0];
        }
    }

    public CellType getType() {
        return this.formula.getType();
    }

    public String getContents() {
        return this.formula.getContents();
    }

    public byte[] getFormulaData() throws FormulaException {
        byte[] d = this.formula.getFormulaData();
        byte[] data = new byte[d.length];
        System.arraycopy(d, 0, data, 0, d.length);
        data[8] = (byte)(data[8] | 2);
        return data;
    }

    public WritableCell copyTo(int col, int row) {
        return new FormulaRecord(col, row, this);
    }
}

