/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox;

import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.encryption.PDStandardEncryption;

public class Encrypt {
    public static void main(String[] args) throws Exception {
        Encrypt encrypt = new Encrypt();
        encrypt.encrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encrypt(String[] args) throws Exception {
        if (args.length < 1) {
            Encrypt.usage();
        } else {
            String infile = args[0];
            String userPassword = "";
            String ownerPassword = "";
            PDDocument document = null;
            try {
                document = PDDocument.load(infile);
                if (!document.isEncrypted()) {
                    PDStandardEncryption enc = new PDStandardEncryption();
                    enc.setVersion(1);
                    enc.setRevision(2);
                    for (int i = 1; i < args.length; ++i) {
                        if (i + 1 >= args.length) {
                            Encrypt.usage();
                        }
                        String key = args[i++];
                        String value = args[i];
                        if (key.equals("-O")) {
                            ownerPassword = value;
                            continue;
                        }
                        if (key.equals("-U")) {
                            userPassword = value;
                            continue;
                        }
                        if (key.equals("-canAssemble")) {
                            enc.setCanAssembleDocument(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canExtractContent")) {
                            enc.setCanExtractContent(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canExtractForAccessibility")) {
                            enc.setCanExtractForAccessibility(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canFillInForm")) {
                            enc.setCanFillInForm(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canModify")) {
                            enc.setCanModify(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canModifyAnnotations")) {
                            enc.setCanModifyAnnotations(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canPrint")) {
                            enc.setCanPrint(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-canPrintDegraded")) {
                            enc.setCanPrintDegraded(value.equalsIgnoreCase("true"));
                            continue;
                        }
                        if (key.equals("-keyLength")) {
                            try {
                                enc.setLength(Integer.parseInt(value));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Error: -keyLength is not an integer '" + value + "'");
                            }
                        }
                        if (key.equals("-version")) {
                            try {
                                enc.setVersion(Integer.parseInt(value));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Error: -version is not an integer '" + value + "'");
                            }
                        }
                        if (key.equals("-revision")) {
                            try {
                                enc.setRevision(Integer.parseInt(value));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new NumberFormatException("Error: -version is not an integer '" + value + "'");
                            }
                        }
                        Encrypt.usage();
                    }
                    document.setEncryptionDictionary(enc);
                    document.encrypt(ownerPassword, userPassword);
                    document.save(infile);
                } else {
                    System.err.println("Error: Document is already encrypted.");
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java org.pdfbox.Encrypt <inputfile> [options]");
        System.err.println("   -O <password>                            Set the owner password");
        System.err.println("   -U <password>                            Set the user password");
        System.err.println("   -canAssemble <true|false>                Set the assemble permission");
        System.err.println("   -canExtractContent <true|false>          Set the extraction permission");
        System.err.println("   -canExtractForAccessibility <true|false> Set the extraction permission");
        System.err.println("   -canFillInForm <true|false>              Set the fill in form permission");
        System.err.println("   -canModify <true|false>                  Set the modify permission");
        System.err.println("   -canModifyAnnotations <true|false>       Set the modify annots permission");
        System.err.println("   -canPrint <true|false>                   Set the print permission");
        System.err.println("   -canPrintDegraded <true|false>           Set the print degraded permission");
        System.err.println("   -keyLength <length>                      The length of the key in bits(40)");
        System.err.println("   -version <0|1|2|3|4>                     The encryption version(1)");
        System.err.println("       0 - Undocumented/Unpublished");
        System.err.println("       1 - Allows for 40 bit encryption");
        System.err.println("       2 - Allows for variable length encryption");
        System.err.println("       3 - Unpublished but allows for key lengths from 40 to 128");
        System.err.println("       4 - Security handler defines encryption");
        System.err.println("   -revision <2|3|4>                        The encryption revision(2)");
        System.err.println("       2 - version less than 2");
        System.err.println("       3 - version 2 or 3 or uses a revision 3 permission");
        System.err.println("       4 - version of 4");
        System.err.println("\nNote: By default all permissions are set to true!");
        System.exit(1);
    }
}

