/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdfviewer;

import java.util.Collections;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.pdfviewer.ArrayEntry;
import org.pdfbox.pdfviewer.MapEntry;
import org.pdfbox.pdmodel.PDDocument;

public class PDFTreeModel
implements TreeModel {
    private PDDocument document;

    public PDFTreeModel() {
    }

    public PDFTreeModel(PDDocument doc) {
        this.setDocument(doc);
    }

    public void setDocument(PDDocument doc) {
        this.document = doc;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public Object getChild(Object parent, int index) {
        Object retval = null;
        if (parent instanceof COSArray) {
            ArrayEntry entry = new ArrayEntry();
            entry.setIndex(index);
            entry.setValue(((COSArray)parent).getObject(index));
            retval = entry;
        } else if (parent instanceof COSStream) {
            COSStream stream = (COSStream)parent;
            retval = this.getChild(stream.getDictionary(), index);
        } else if (parent instanceof COSDictionary) {
            COSDictionary dict = (COSDictionary)parent;
            List keys = dict.keyList();
            Collections.sort(keys);
            Object key = keys.get(index);
            COSBase value = dict.getDictionaryObject((COSName)key);
            MapEntry entry = new MapEntry();
            entry.setKey(key);
            entry.setValue(value);
            retval = entry;
        } else if (parent instanceof MapEntry) {
            retval = this.getChild(((MapEntry)parent).getValue(), index);
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChild(((ArrayEntry)parent).getValue(), index);
        } else if (parent instanceof COSDocument) {
            retval = ((COSDocument)parent).getObjects().get(index);
        } else if (parent instanceof COSObject) {
            retval = ((COSObject)parent).getObject();
        } else {
            throw new RuntimeException("Unknown COS type " + parent.getClass().getName());
        }
        return retval;
    }

    public int getChildCount(Object parent) {
        int retval = 0;
        if (parent instanceof COSArray) {
            retval = ((COSArray)parent).size();
        } else if (parent instanceof COSDictionary) {
            retval = ((COSDictionary)parent).size();
        } else if (parent instanceof MapEntry) {
            retval = this.getChildCount(((MapEntry)parent).getValue());
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChildCount(((ArrayEntry)parent).getValue());
        } else if (parent instanceof COSStream) {
            retval = this.getChildCount(((COSStream)parent).getDictionary());
        } else if (parent instanceof COSDocument) {
            retval = ((COSDocument)parent).getObjects().size();
        } else if (parent instanceof COSObject) {
            retval = 1;
        }
        return retval;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int retval = -1;
        if (parent != null && child != null) {
            if (parent instanceof COSArray) {
                COSArray array = (COSArray)parent;
                if (child instanceof ArrayEntry) {
                    ArrayEntry arrayEntry = (ArrayEntry)child;
                    retval = arrayEntry.getIndex();
                } else {
                    retval = array.indexOf((COSBase)child);
                }
            } else if (parent instanceof COSDictionary) {
                MapEntry entry = (MapEntry)child;
                COSDictionary dict = (COSDictionary)parent;
                List keys = dict.keyList();
                Collections.sort(keys);
                for (int i = 0; retval == -1 && i < keys.size(); ++i) {
                    if (!keys.get(i).equals(entry.getKey())) continue;
                    retval = i;
                }
            } else if (parent instanceof MapEntry) {
                retval = this.getIndexOfChild(((MapEntry)parent).getValue(), child);
            } else if (parent instanceof COSStream) {
                retval = this.getIndexOfChild(((COSStream)parent).getDictionary(), child);
            } else if (parent instanceof ArrayEntry) {
                retval = this.getIndexOfChild(((ArrayEntry)parent).getValue(), child);
            } else if (parent instanceof COSDocument) {
                retval = ((COSDocument)parent).getObjects().indexOf(child);
            } else if (parent instanceof COSObject) {
                retval = 0;
            } else {
                throw new RuntimeException("Unknown COS type " + parent.getClass().getName());
            }
        }
        return retval;
    }

    public Object getRoot() {
        return this.document.getDocument().getTrailer();
    }

    public boolean isLeaf(Object node) {
        boolean isLeaf = !(node instanceof COSDictionary || node instanceof COSArray || node instanceof COSStream || node instanceof COSDocument || node instanceof COSObject || node instanceof MapEntry && !this.isLeaf(((MapEntry)node).getValue()) || node instanceof ArrayEntry && !this.isLeaf(((ArrayEntry)node).getValue()));
        return isLeaf;
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

