/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.image.PDXObjectImage;

public class PDPixelMap
extends PDXObjectImage {
    private Image image = null;

    public PDPixelMap(PDStream stream) {
        super(stream, "png");
    }

    public Image getRGBImage() throws IOException {
        if (this.image != null) {
            return this.image;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int bpc = this.getBitsPerComponent();
        COSInteger length = (COSInteger)this.stream.getStream().getDictionary().getDictionaryObject(COSName.LENGTH);
        byte[] array = this.stream.getByteArray();
        PDColorSpace colorspace = this.getColorSpace();
        ColorModel cm = colorspace.createColorModel(bpc);
        WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
        DataBufferByte buffer = (DataBufferByte)raster.getDataBuffer();
        byte[] bufferData = buffer.getData();
        System.arraycopy(array, 0, bufferData, 0, array.length);
        this.image = new BufferedImage(cm, raster, false, null);
        return this.image;
    }

    public void write2OutputStream(OutputStream out) throws IOException {
        this.getRGBImage();
        if (this.image != null) {
            ImageIO.write((RenderedImage)((BufferedImage)this.image), "png", out);
        }
    }
}

