/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.image;

import java.awt.Image;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDColorSpaceFactory;

public abstract class PDXObjectImage
implements COSObjectable {
    protected PDStream stream;
    private String suffix;

    public PDXObjectImage(PDStream imageStream, String fileSuffix) {
        this.stream = imageStream;
        this.suffix = fileSuffix;
    }

    public COSBase getCOSObject() {
        return this.stream.getCOSObject();
    }

    public abstract Image getRGBImage() throws IOException;

    public abstract void write2OutputStream(OutputStream var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write2file(String filename) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(filename + "." + this.suffix);
            this.write2OutputStream(out);
            out.flush();
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public int getHeight() {
        return this.stream.getStream().getDictionary().getInt("Height", -1);
    }

    public void setHeight(int height) {
        this.stream.getStream().getDictionary().setInt("Height", height);
    }

    public int getWidth() {
        return this.stream.getStream().getDictionary().getInt("Width", -1);
    }

    public void setWidth(int width) {
        this.stream.getStream().getDictionary().setInt("Width", width);
    }

    public int getBitsPerComponent() {
        return this.stream.getStream().getDictionary().getInt(new String[]{"BPC", "BitsPerComponent"}, -1);
    }

    public void setBitsPerComponent(int bpc) {
        this.stream.getStream().getDictionary().setInt("BitsPerComponent", bpc);
    }

    public PDColorSpace getColorSpace() throws IOException {
        COSBase cs = this.stream.getStream().getDictionary().getDictionaryObject(new String[]{"CS", "ColorSpace"});
        PDColorSpace retval = null;
        if (cs != null) {
            retval = PDColorSpaceFactory.createColorSpace(cs);
        }
        return retval;
    }

    public void setColorSpace(PDColorSpace cs) {
        COSBase base = null;
        if (cs != null) {
            base = cs.getCOSObject();
        }
        this.stream.getStream().getDictionary().setItem(COSName.getPDFName("ColorSpace"), base);
    }

    public String getSuffix() {
        return this.suffix;
    }
}

