/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.ttf;

import java.io.IOException;
import org.pdfbox.ttf.HorizontalHeaderTable;
import org.pdfbox.ttf.MaximumProfileTable;
import org.pdfbox.ttf.TTFDataStream;
import org.pdfbox.ttf.TTFTable;
import org.pdfbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        int numHMetrics = hHeader.getNumberOfHMetrics();
        int numGlyphs = maxp.getNumGlyphs();
        this.advanceWidth = new int[numHMetrics];
        this.leftSideBearing = new short[numHMetrics];
        for (int i = 0; i < numHMetrics; ++i) {
            this.advanceWidth[i] = data.readUnsignedShort();
            this.leftSideBearing[i] = data.readSignedShort();
        }
        int numberNonHorizontal = numGlyphs - numHMetrics;
        this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
        for (int i = 0; i < numberNonHorizontal; ++i) {
            this.nonHorizontalLeftSideBearing[i] = data.readSignedShort();
        }
    }

    public int[] getAdvanceWidth() {
        return this.advanceWidth;
    }

    public void setAdvanceWidth(int[] advanceWidthValue) {
        this.advanceWidth = advanceWidthValue;
    }
}

