/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 * 
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 * 
 * This program is a free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.ThreadAction;

import java.io.*;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.Lucene.LuceneActions;



/**
 * Classe utilisant des Threads pour indexer des documents.
 * <br/><br/>
 * Class using threads for indexing documents.
 * 
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
public class ThreadIndexing
    extends Thread {

  private String toIndex = null;
  private String indexDir = "";
  private String fichierXMLConfig = "";

  public ThreadIndexing(String toIndex,
                        String indexDir,
                        String fichierXMLConfig) {
    this.toIndex = toIndex;
    this.indexDir = indexDir;
    this.fichierXMLConfig = fichierXMLConfig;
  }
  public ThreadIndexing(String toIndex,
                        String indexDir,
                        String fichierXMLConfig,
                        String type) {
    this.toIndex = toIndex;
    this.indexDir = indexDir;
    this.fichierXMLConfig = fichierXMLConfig;
  }


  public void run() {

    try {

      LuceneActions.getSingletonInstance().index(toIndex, indexDir,
                                                 fichierXMLConfig);

      try {
        Thread.sleep(1000);
      }
      catch (InterruptedException ex) {
        ex.printStackTrace();
      }
    }
    catch (LiusException e) {
      e.printStackTrace();
    }
    catch (IOException e) {
      e.printStackTrace();
    }

  }
}