/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.index;

import java.util.List;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.index.Excel.ExcelIndexer;
import ca.ulaval.bibl.lius.index.HTML.HtmlIndexer;
import ca.ulaval.bibl.lius.index.MSWord.WordIndexer;
import ca.ulaval.bibl.lius.index.PDF.PdfIndexer;
import ca.ulaval.bibl.lius.index.RTF.RTFIndexer;
import ca.ulaval.bibl.lius.index.TXT.TXTIndexer;
import ca.ulaval.bibl.lius.index.XML.XmlFileIndexer;
import ca.ulaval.bibl.lius.index.OpenOffice.OOIndexer;
import ca.ulaval.bibl.lius.index.PowerPoint.PPTIndexer;



/**
 * @author Rida Benjelloun
 */

public class IndexerFactory {

  public static Indexer getIndexer(String fileName) throws LiusException {
    Indexer indexer = null;
    if (fileName.toLowerCase().endsWith(".xml")) {
      indexer = new XmlFileIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".pdf")) {
      indexer = new PdfIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".html") ||
             fileName.toLowerCase().endsWith(".htm") ||
             fileName.toLowerCase().endsWith(".jsp") ||
             fileName.toLowerCase().endsWith(".asp") ||
             fileName.toLowerCase().endsWith(".aspx")) {
      indexer = new HtmlIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".doc")) {
      indexer = new WordIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".xls")) {
      indexer = new ExcelIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".rtf")) {
      indexer = new RTFIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".txt")) {
      indexer = new TXTIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".sxw") ||
             fileName.toLowerCase().endsWith(".sxc") ||
             fileName.toLowerCase().endsWith(".sxi") ||
             fileName.toLowerCase().endsWith(".stw")) {
      indexer = new OOIndexer();
    }
    else if (fileName.toLowerCase().endsWith(".ppt")) {
      indexer = new PPTIndexer();
    }

    else if (fileName.toLowerCase().endsWith(".gif") ||
             fileName.toLowerCase().endsWith(".jpg") ||
             fileName.toLowerCase().endsWith(".png") ||
             fileName.toLowerCase().endsWith(".tif") ||
             fileName.toLowerCase().endsWith(".eps") ||
             fileName.toLowerCase().endsWith(".svg") ||
             fileName.toLowerCase().endsWith(".ps")) {
      indexer = null;

    }
    else {
      throw new LiusException("Le fichier : " + "\"" + fileName +
                              "\" n'est pas support par Lius");
    }
    return indexer;
  }

  public static Indexer getIndexer(String fileName, List elemToIndex) throws
      LiusException {
    Indexer indexer = null;
    for (int i = 0; i < elemToIndex.size(); i++) {
      if (fileName.toLowerCase().endsWith(".xml") &&
          elemToIndex.get(i).toString().equalsIgnoreCase("xml")) {
        indexer = new XmlFileIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".pdf") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("pdf")) {
        indexer = new PdfIndexer();
        break;
      }
      else if ( (fileName.toLowerCase().endsWith(".html") ||
                 fileName.toLowerCase().endsWith(".htm") ||
                 fileName.toLowerCase().endsWith(".jsp") ||
                 fileName.toLowerCase().endsWith(".asp") ||
                 fileName.toLowerCase().endsWith(".aspx")) &&
               elemToIndex.get(i).toString().equalsIgnoreCase("html")) {
        indexer = new HtmlIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".doc") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("msword")) {
        indexer = new WordIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".rtf") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("rtf")) {
        indexer = new RTFIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".xls") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("msexcel")) {
        indexer = new ExcelIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".gif") ||
               fileName.toLowerCase().endsWith(".jpg") ||
               fileName.toLowerCase().endsWith(".png") ||
               fileName.toLowerCase().endsWith(".tif") ||
               fileName.toLowerCase().endsWith(".eps") ||
               fileName.toLowerCase().endsWith(".svg") ||
               fileName.toLowerCase().endsWith(".ps")) {
        indexer = null;
        break;
      }
      else if (fileName.toLowerCase().endsWith(".txt") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("txt")) {
        indexer = new TXTIndexer();
        break;
      }
      else if ( (fileName.toLowerCase().endsWith(".sxw") ||
                 fileName.toLowerCase().endsWith(".sxc") ||
                 fileName.toLowerCase().endsWith(".sxi") ||
                 fileName.toLowerCase().endsWith(".stw")) &&
               elemToIndex.get(i).toString().equalsIgnoreCase("openoffice")) {
        indexer = new OOIndexer();
        break;
      }
      else if (fileName.toLowerCase().endsWith(".ppt") &&
               elemToIndex.get(i).toString().equalsIgnoreCase("mspowerpoint")) {
        indexer = new PPTIndexer();
        break;
      }

    }
    if (indexer == null)
      throw new LiusException("Le fichier : " + "\"" + fileName +
                              "\" n'est pas support par Lius");
    return indexer;
  }

  public static Indexer flush() {
    return null;
  }

//org.apache.turbine.services.mimetype.util.MimeTypeMap

}