/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.index.JavaObject;

/**
 * @author Rida Benjelloun
 */
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

import org.apache.lucene.document.Document;

import ca.ulaval.bibl.lius.Lucene.LuceneActions;
import ca.ulaval.bibl.lius.config.LiusConfig;
import ca.ulaval.bibl.lius.config.LiusConfigBuilder;
import ca.ulaval.bibl.lius.config.LiusField;
import ca.ulaval.bibl.lius.index.Indexer;

/**
 * Classe permettant d'indexer des objets JavaBeans
 * <br/><br/>
 * Class for indexing JavaBeans objects.
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 *
 */
public class BeanIndexer
    extends Indexer {

  /**
   * Mthode retournant un objet de type Lucene document  partir du fichier 
   * indexer et du fichier de configuration de Lius.
   * <br/><br/>
   * Method that returns a Lucene document object from the file to index and
   * the Lius configuration file.
   */
  public Document createLuceneDocument(Object bean,
                                       String liusXmlConfigFilePath) {
    LiusConfig lc = LiusConfigBuilder.getSingletonInstance().
        getLiusConfig(liusXmlConfigFilePath);
    Document doc = createLuceneDocument(bean, lc);
    return doc;
  }

  /**
   * Mthode retournant un objet de type Lucene document  partir du fichier
   *  indexer et du fichier de configuration de Lius exprim sous forme
   * d'objet de type LiusConfig.
   * <br/><br/>
   * Method that returns a Lucene document object from a file to index and
   * the Lius configuration as a LiusConfig object.
   */
  public Document createLuceneDocument(Object bean, LiusConfig lc) {
    Collection collRes = getPopulatedCollection( bean,  lc);
    Document doc = LuceneActions.getSingletonInstance().populateLuceneDoc(collRes);
    return doc;
  }


  public Collection getLiusFields(LiusConfig lc) {
    return null;
  }

  public Collection getPopulatedCollection(Object bean, Collection liusFields) {
    Collection collRes = new ArrayList();
    try {
      Class c = bean.getClass();
      Iterator i = liusFields.iterator();
      while (i.hasNext()) {
        LiusField lf = (LiusField) i.next();
        Method m = c.getMethod(lf.getGetMethod(), null);
        Object o = m.invoke(bean, null);
        String value = o.toString();
        lf.setValue(value);
        collRes.add(lf);
      }
    }
    catch (NoSuchMethodException e) {
      e.printStackTrace();
    }
    catch (IllegalAccessException e) {
      e.printStackTrace();
    }
    catch (InvocationTargetException e) {
      e.printStackTrace();
    }
    return collRes;
  }

  public Collection getPopulatedCollection(Object bean, String liusConfig) {
    LiusConfig lc = LiusConfigBuilder.getSingletonInstance().getLiusConfig(
        liusConfig);
    return getPopulatedCollection(bean, lc);
  }

  public Collection getPopulatedCollection(Object bean, LiusConfig lc) {
    Class c = bean.getClass();
    Map config = lc.getJavaBeansFields();
    Document doc = null;
    Collection liusFields = (Collection) config.get(c.getName());
    return getPopulatedCollection(bean, liusFields);
  }

  public Document createLuceneDocument(String file, LiusConfig lc) {
    return null;
  }
}