/*
 * LIUS - Lucene Index Update and Search
 * http://sourceforge.net/projects/lius/
 *
 * Copyright (c) 2004, Laval University Library.  All rights reserved.
 *
 * This program is a free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
package ca.ulaval.bibl.lius.main;

/**
 * @author Rida Benjelloun (rida.benjelloun@bibl.ulaval.ca)
 */
import java.util.Vector;
import java.util.List;

import ca.ulaval.bibl.lius.config.LiusField;
import java.io.IOException;
import ca.ulaval.bibl.lius.search.SearchIndex;
import java.util.ArrayList;


public class TestUtils {

  public static void main(String[] args) throws IOException {
    SearchIndex si = new SearchIndex();
    String config ="C:\\Documents and Settings\\Rida\\Mes documents\\java\\LiusOS\\Config\\liusFilesConfig.xml";
    List indexs = new ArrayList();
    indexs.add("C:\\test");
    indexs.add("C:\\Documents and Settings\\Rida\\Mes documents\\java\\LiusOS\\luceneIndex");
    List res = si.multiIndexSearch("ca*",indexs,config);
    print(res);

  }

  public static void print(List ls) {
    System.out.println("Nb doc = " + ls.size());
    for (int i = 0; i < ls.size(); i++) {
      List document = (List) ls.get(i);
      for (int j = 0; j < document.size(); j++) {
        LiusField lf = (LiusField) document.get(j);
        String name = lf.getLabel();
        Vector values = values = lf.getValues();
        System.out.print(name + " : ");
        for (int k = 0; k < values.size(); k++) {
          System.out.println("\t" + values.get(k));
        }
      }
      System.out.println("==============================");
    }
  }

}