package org.injac.indexing.index;

import java.io.File;
import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;
import org.injac.indexing.beans.IndexListBean;
import org.injac.indexing.util.BeanPhoenix;
import org.injac.indexing.util.FileTools;
import org.injac.indexing.util.MetadataMode;

public class GenericIndexingServlet extends HttpServlet {
	protected static Logger logger = Logger
			.getLogger(GenericIndexingServlet.class);

	protected String indexPath;

	public GenericIndexingServlet() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected int extractMode(String mode) {
		int result = MetadataMode.NONE;
		if (mode != null) {
			try {
				result = Integer.parseInt(mode);

			} catch (Exception e) {
				logger.error("bad metadata indexing mode : " + mode
						+ " (no metadata will be indexed)");
			}
		}
		return result;
	}

	/**
	 * Create index directory and Temp directory for uploaded document
	 * 
	 * @param indexName
	 * @param create
	 *            if set to true, empty index directory
	 * @return
	 */
	protected File createFiles(String indexName, boolean create) {
		createIndexDirectory(indexName, create);

		File temp = new File(indexPath + "/Temp/" + indexName);
		if (!temp.exists()) {
			temp.mkdirs();
		} else {
			FileTools.clearDir(temp);
		}
		return temp;
	}

	protected File createIndexDirectory(String indexName, boolean create) {
		File index = new File(indexPath + "/" + indexName);
		if (!index.exists()) {
			if (index.mkdirs()) {
				logger.debug("creating " + indexPath + "/" + indexName
						+ " for new index");
			} else {
				return null;
			}
		}
		if (create == true) {
			// clear dir
			FileTools.clearDir(index);
		}

		return index;
	}

	protected boolean deleteTemps(File temp) {
		String rootTemp = temp.getAbsolutePath().substring(0,
				temp.getAbsolutePath().lastIndexOf("Temp") + 4);

		File rootTempFile = new File(rootTemp);
		return FileTools.deleteDir(rootTempFile);
	}

	protected int saveBean(HttpServletResponse response, HttpSession session,
			String indexName, String url, String user, String password,
			int mdMode) {

		String beanPath = indexPath + "/" + IndexListBean.class.getName()
				+ ".ser";

		javax.servlet.ServletContext context = session.getServletContext();
		IndexListBean indexListBean = (IndexListBean) context
				.getAttribute("indexListBean");
		if (indexListBean == null) {
			indexListBean = (IndexListBean) BeanPhoenix.loadBean(beanPath);
			context.setAttribute("indexListBean", indexListBean);
		}
		int newIndex = -1;
		if (indexListBean != null) {
			newIndex = indexListBean.addIndex(indexName, url, user, password,
					mdMode);
			if (newIndex == -1) {
				return -1;
			}
			context.setAttribute("indexListBean", indexListBean);
			// save bean

			BeanPhoenix.saveBean(indexListBean, beanPath);
		} else {
			return -1;
		}
		return newIndex;

	}

	protected void undoSaveBean(Object bean, int newIndex) {
		String beanPath = indexPath + "/";

		BeanPhoenix.saveBean(bean, beanPath + bean.getClass().getName()
				+ ".ser");
	}
}
