/*
 * Created on 17 mai 2006
 *
 * Class for indexg string OAI records with RAMDirectory 
 * 
 */
package org.injac.indexing.index.oaipmh;


import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.injac.indexing.index.IIndexing;

import ca.ulaval.bibl.lius.Lucene.LuceneActions;


/**
 * Classe executant l'indexation  partir d'une chaine XML
 * 
 * Usage : 1/ crer une instance
 * 
 * 2/ appeler index autant de fois qu'il y a de documents  indexer
 * 
 * 3/ drfrencer pour la dsallocation mmoire
 * 
 * @authors Franois Jannin
 */
public class RamStringOAIIndexing extends StringOAIIndexing implements IIndexing {


	static Logger logger = Logger.getLogger(RamStringOAIIndexing.class);


	private IndexWriter ramIndexWriter = null;
	private RAMDirectory ramDir = null;

	public RamStringOAIIndexing(){
		super();
	}
	
	public RamStringOAIIndexing(String indexName) {
		super(indexName);
	
	}

	protected IndexWriter getIndexWriter(){
		return ramIndexWriter;
	}
	
	/**
	 * Create index Writer
	 *
	 */
	public void open(){
		count= 0;
		String indexDir = indexPath + "/" + indexName;
		try{
			boolean createIndex = LuceneActions.getSingletonInstance()
					.createIndexValue(liusConfig.getCreateIndex(), indexDir);
			ramDir    = new RAMDirectory();
			ramIndexWriter = new IndexWriter(ramDir, analyzer, createIndex);

			LuceneActions.getSingletonInstance().setIndexWriterProps(ramIndexWriter,
					liusConfig);
		}catch(Exception e){
			logger.error(e + " : "+ e.getLocalizedMessage());
		}

	}
	/**
	 * Close index Writer
	 *
	 */
	public void close(){
		String indexDir = indexPath + "/" + indexName;
		try{
			boolean createIndex = LuceneActions.getSingletonInstance()
					.createIndexValue(liusConfig.getCreateIndex(), indexDir);
			IndexWriter fsIndexWriter = new IndexWriter(indexDir, analyzer, createIndex);

			LuceneActions.getSingletonInstance().setIndexWriterProps(fsIndexWriter,
					liusConfig);
			fsIndexWriter.addIndexes(new Directory[] { ramDir });
			ramIndexWriter.close();
			fsIndexWriter.close();
		}catch(Exception e){
			logger.error(e + " : "+ e.getLocalizedMessage());
		}	
	}
	
	

	

}
