package org.injac.indexing.lius;

import ca.ulaval.bibl.lius.Exception.LiusException;
import ca.ulaval.bibl.lius.index.Indexer;
import ca.ulaval.bibl.lius.index.IndexerFactory;

import org.injac.indexing.lius.XML.XmlStreamIndexer;

public class CustomizedIndexerFactory extends IndexerFactory {
	 public static Indexer getIndexer(String fileName) throws LiusException {
		    Indexer indexer = null;
		    if (fileName.toLowerCase().equals("xml")) {
		      indexer = new XmlStreamIndexer();
		    }
		    else {
		    	return IndexerFactory.getIndexer(fileName);
		    }
		    return indexer;
		  }
	
}
