/*
 * Created on 24 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.indexing.show;

import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.ArrayList;
import javax.servlet.GenericServlet;
import javax.servlet.http.*;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import org.apache.lucene.index.IndexReader;

import org.injac.indexing.beans.*;
import org.injac.indexing.util.BeanPhoenix;

/**
 * Classe permettant d'afficher dans une page web les noms complets (url) de
 * tous les fichiers d'un index
 * 
 * @author Franois Jannin
 */
public class ListIndex extends IndexReaderServlet {
	static Logger logger = Logger.getLogger("INJAC_INDEX");

	private int docPerPage = 100;

	public ListIndex() {
		super();

	}

	/**
	 * Fonction qui ecrit dans le PrintWriter writer les noms des fichiers de
	 * l'index indexDir
	 * 
	 * @param indexDir
	 * @param writer
	 */
	protected void show(HttpServletRequest request, String indexName,
			File indexDir, java.io.PrintWriter writer) {

		String pageCountStr = resBundle.getString("maxPageCount");
		String startStr = request.getParameter("start");

		int start = 0;
		docPerPage = checkParseInt(pageCountStr, 100);
		start = checkParseInt(startStr, 0);

		try {
			IndexReader reader = IndexReader.open(indexDir);
			String adress = null;
			String name = null;
			int n = reader.numDocs();
			int npages = n / docPerPage;
			if (npages * docPerPage < n)
				npages++;
			int currentPage = (start / docPerPage) + 1;
			int end = (start + docPerPage) > n ? n : (start + docPerPage);
			
			writer.println("<div id=\"doclist\">");

			writer.println("<h1>Liste des documents de l'index " + indexName
					+ "</h1>");
			writer.println("<h3>Page " + currentPage + " /" + npages
					+ " : documents " + (start + 1) + " - " + end + "/" + n
					+ "</h3>");
			
			writer.println("<div class=\"pagelinks\">");
			printPageLinks(currentPage, npages, writer);
			writer.println("</div>");
			
			String events = "";// " onMouseout=\"hideCurrentPopup(); return
								// false;\"";
			writer.println("<ul class=\"indexdocs\" " + events + ">");

			for (int i = start; i < end; i++) {
				if (!reader.isDeleted(i)) {
					Document d = reader.document(i);
					adress = d.get("url");
					if (adress == null) {
						// return value of field indexed by exist.ExistIndexing
						adress = d.get("renderURL");

					} else {
						// return value of field indexed by webdav.InjacIndexing
						name = d.get("name");

						adress = adress + "/" + name;

					}
					// print document adress
					String li_id = "li" + i;
					events = "onMouseOver=\"changeColorObject('" + li_id
							+ "', 'blue');\"";
					events += " onMouseout=\"changeColorObject('" + li_id
							+ "', 'black');\"";
					events += " onClick=\"showPopupMod(" + index + "," + i
							+ ", '" + li_id + "');\"";
					writer.println("<li id=\"li" + i + "\" " + events + ">"
							+ adress + "</li>");

				} else {
					n++;
				}
			}

			writer.println("</ul>");
			writer.println("</div>");
			
			writer.println("<div class=\"pagelinks\">");
			printPageLinks(currentPage, npages, writer);
			writer.println("</div>");
			// fermeture des balise div#iDorrenderer et div#page
			writer.println("</div>");
			writer.println("</div>");
				
			// balise en dehors de page
			events=" onMousedown=\"selectMouse(event);\" onMouseMove=\"mouseMove(event);\"";//onMouseup=\"mouseUp();\"
			String style ="style='right: 0;top: 98; width: 200px;'";
			writer.println("<div "+style+" id=\"fieldswidget\""+events+"><div id=\"htmlfields\">Cliquez sur un document pour visualiser les champs indexs</div></div>");
			
			// ouverture de deux div factices imbriques
			writer.println("<div>");
			writer.println("<div>");
			
			
			reader.close();
		}

		catch (IOException ioe) {
			ioe.printStackTrace();
		}
	}

	private void printPageLinks(int current, int pages,
			java.io.PrintWriter writer) {
		int startPage = current >= 12 ? current - 10 : 1;
		int endPage = current + 9 <= pages ? current + 9 : pages;
		try {
			if (startPage > 1) {
				writer.println(linkForPage(1, "page 1"));
			}
			for (int i = startPage; i <= endPage; i++) {
				writer.println(linkForPage(i, "" + i));
			}
			if (current < pages)
				writer.println(linkForPage(current + 1, "suivante"));
			if (endPage < pages) {
				writer.println(linkForPage(pages, "page " + pages));
			}
		} catch (Exception e) {
			logger.error(e.getLocalizedMessage());
		}

	}

	private String linkForPage(int page, String text) {
		return "<a href=\"?menu=listIndex&index=" + index + "&start="
				+ (page - 1) * docPerPage + "\">" + text + "</a>";
	}
}
