<%@page contentType="text/html" session="true"%>
<jsp:useBean id="indexListBean" scope="application" 
	class="org.injac.indexing.beans.IndexListBean" />
<jsp:useBean id="conf" scope="application"
	class="org.injac.indexing.ConfInfos" />	
<jsp:useBean id="httpsUrl" scope="application"
	class="java.lang.String" />	
<jsp:useBean id="selIndex" scope="session"
	class="java.lang.String" />		
<%@page import="org.injac.indexing.util.*"%>	
<%@page import="org.injac.indexing.beans.IndexListBean"%>
<%@page import="java.util.ResourceBundle"%>
<%@page import="java.util.Map"%>
<%@page import="org.apache.log4j.Logger"%>

<%!	
	static Logger logger = Logger.getLogger("INJAC_INDEX");
	ResourceBundle resBundle;
	Map menus;
	boolean initBean=false;
	public void jspInit() {
		// init resource for configuration file
		try{
			logger.debug("jspInit index.jsp");
			resBundle = ResourceBundle.getBundle("indexation");
		}catch(Exception e){
			logger.error("Resource error : indexation.properties; " + e.getStackTrace());
		}
		// init IndexListBean from file
		try{
			javax.servlet.ServletContext context =getServletContext();
			IndexListBean indexListBean = (IndexListBean)context.getAttribute("indexListBean");
			
			String beanPath = resBundle.getString("indexPath")+"/";	
			if(indexListBean==null){
				indexListBean = new IndexListBean();
			
				indexListBean = (IndexListBean)BeanPhoenix.loadBean(beanPath+indexListBean.getClass().getName()+".ser");
				if(indexListBean !=null){
					context.setAttribute("indexListBean", indexListBean);
				}
			}	
		
		}catch(Exception e){
			logger.error(e.getMessage());
		}

	}
%>

<%// initialization 

	// init selIndex bean
	if(selIndex.equals("")){
		selIndex=(indexListBean.getList().size()>0)?"0":"-1";
	}
	String changeIndex = request.getParameter("index");
	if(changeIndex != null)
		selIndex= changeIndex;	
	if(resBundle ==null){
		resBundle =ResourceBundle.getBundle("indexation");
		
	}
	conf.init(resBundle);
	if(conf.indexPath==null)
		conf.indexPath="null";
	String menu = request.getParameter("menu");
	String includeFile = "welcome.html";
	// Menu management
	if (menu != null) {
		if (menu.equalsIgnoreCase("newIndex")) {
			includeFile =  "indexation.jsp";
		}
		else if (menu.equalsIgnoreCase("indexReport")) {
			includeFile = "indexReport.jsp";
		}
		else if (menu.equalsIgnoreCase("showIndex")) {
			includeFile = "showIndex.jsp";
		}
		else if (menu.equalsIgnoreCase("deleteIndex")) {
			String pass= request.getParameter("pass");
			int indexi = Integer.parseInt(changeIndex);
			if(pass.equals(indexListBean.getPassword(indexi))){
				// delete entry from bean, and set a new selected index
				selIndex = ""+indexListBean.removeIndex(indexi);
				// save bean into file
				BeanPhoenix.saveBean(indexListBean, conf.indexPath+"/"+indexListBean.getClass().getName()+".ser");
				
				includeFile = "deleteIndexResult.jsp";
			}else {
				includeFile = "errorIndexAction.jsp";
			}
		}
		else if (menu.equalsIgnoreCase("listIndex")) {
			
			includeFile = "servletListIndex";//?index="+Integer.parseInt(selIndex);
		}
		else if (menu.equalsIgnoreCase("updateIndex")) {
			// delete entry from bean, and set a new selected index
			includeFile = "servletUpdateIndex";//?index="+Integer.parseInt(selIndex);
		}
	}	
	else {
		menu = "welcome";
		if(!selIndex.equals("-1")){
			includeFile="showIndex.jsp";
			request.setAttribute("index", selIndex);
		}
	}
	if(!request.getRequestURL().substring(0,5).equalsIgnoreCase("https")
			&&
		conf.forceSSL.equalsIgnoreCase("true")) {		
	
		httpsUrl = "https"+request.getRequestURL().substring(4);
		// change port if necessary
		int slash = httpsUrl.indexOf("/",8);
		String prestring = httpsUrl.substring(0,slash);
		
		if(prestring.indexOf(":",6)!=-1){
			prestring = prestring.substring(0,prestring.indexOf(":",6));
		}
		httpsUrl = prestring+conf.httpsPort+httpsUrl.substring(slash);
	}
	else {
		httpsUrl = request.getRequestURL().toString();
	}

%>

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Indexation Injac</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
<link href="css/style_1.css" rel="stylesheet" type="text/css">
<script src="scripts/utility.js"></script>
<script src="scripts/fieldspopup.js"></script>
<% if(includeFile.equalsIgnoreCase("servletListIndex")){ %>
<!--[if IE]>
	<link
	 href="css/fixed4ie.css"
	 rel="stylesheet"
	 type="text/css"
	 media="screen">
	<script type="text/javascript">
	onload = function() { content.focus() }
	</script>
<![endif]-->
<%} %>
</head>

<body>
<div id="header">
<h1><img src="images/logo_haut_1.gif" height="98" width="799"></h1>
</div>
<div id="login">
<h1>Injac - Indexation</h1>
</div>
<div id="page">



<div id="menu">
<div id="navbar"></div>

<div id="sectionMenu">
<div id="iNavPan">
<h2>Menu</h2>
<ul class="ispaces">
	<li class="<%=(menu.equals("welcome")?"seldoc":"doc") %>"><a title="Accueil"
		href="?menu=welcome">Accueil</a></li>
	<li class="<%=(menu.equals("newIndex")?"seldoc":"doc") %>">
<% if(conf.forceSSL.equalsIgnoreCase("true")) { %>	
	<a
		title="Nouvel index" href="<%= httpsUrl %>?menu=newIndex">Nouvel index</a>
<%}else { %>
	<a
		title="Nouvel index" href=".?menu=newIndex">Nouvel index</a>
<% 		} %>		
	</li>
<% if(!selIndex.equals("-1")) { %>	
	<li class="<%=(menu.equals("listIndex")?"seldoc":"doc") %>"><a
		title="voir l'index" href=".?menu=listIndex&amp;index=<%=Integer.parseInt(selIndex)  %>">Visualiser l'index</a></li>
<% } %>
</ul>
<h2>Liste des index</h2>
<ul class="idocs">
	<%if (indexListBean != null) {
			int indexCount = indexListBean.getList().size();
			String CSSClass;
			for (int i = 0; i < indexCount; i++) {
				String indexName = indexListBean.getName(i);
				if(Integer.parseInt(selIndex) == i)
					CSSClass= "seldoc";
				else
					CSSClass="doc";
%>

	<li class="<%= CSSClass %>"><a title="<%=indexName %>"
		href="<%=httpsUrl %>?menu=showIndex&amp;index=<%=i %>"><%=indexName%></a></li>
	<%		}
	  }%>
</ul>
</div>
<div id="gentools"> 
<div class="tool">
<h2>Chercher</h2>
<% if(!selIndex.equals("-1")) { %>
<p>Index slectionn : <%= indexListBean.getName( Integer.parseInt(selIndex) ) %></p>
<ul>
	<li>
	<form action="htmlSearch"><input name="query" size="19">
		<input name="name" value="<%= indexListBean.getName( Integer.parseInt(selIndex) ) %>" type="hidden">
	</form>
	</li>
</ul>
<% }else { %>
<p>Slectionner un index</p>
<% } %>
</div>

</div>
<% if(conf.debug.equalsIgnoreCase("on")) { %>
<table border="1" bordercolor="black">
<theader><th>Infos Debug :</th></theader>
<tbody>
<tr><td>Rpertoire d'index : </td><td><%=conf.indexPath%></td></tr>
<tr><td>https Port : </td><td><%=conf.httpsPort %></td></tr>
</tbody>
</table>
<% } %>
</div>
</div>

<div id="iDocRender">
<!-- affichage option choisie -->
 <jsp:include page='<%= includeFile %>' />
<!-- Fin affichage option choisie -->
</div>

</div>
</body>
</html>
