/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.RecordHandler.RecordHandler;
import ORG.oclc.RecordHandler.UnrecognizedRecordHandlerException;
import ORG.oclc.ber.DataDir;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.pears.util.MissingParameterException;
import ORG.oclc.util.IllegalParameterException;
import ORG.oclc.util.IniFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class MarcDataDirRecordFactory
extends RecordFactory {
    private static boolean debug = false;
    private static RecordHandler recordHandler = null;
    protected String oaiIdentifierPrefix;

    public static RecordHandler getRecordHandler() {
        return recordHandler;
    }

    public MarcDataDirRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        this.oaiIdentifierPrefix = properties.getProperty("MarcDataDirRecordFactory.oaiIdentifierPrefix");
        if (this.oaiIdentifierPrefix == null) {
            throw new IllegalArgumentException("MarcDataDirRecordFactory.oaiIdentifierPrefix is missing from properties file");
        }
        if (recordHandler == null) {
            try {
                recordHandler = RecordHandler.getHandler((String)"USMARC");
                StringReader sr = new StringReader("[HandleUSMARC]\nlocalcharconverter=USM94\nignoreRecoverableErrors=true\n");
                IniFile rhIni = new IniFile((Reader)sr);
                recordHandler.Input((InputStream)null, rhIni);
            }
            catch (MissingParameterException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Illegal Parameter");
            }
            catch (IllegalParameterException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Illegal Parameter");
            }
            catch (UnrecognizedRecordHandlerException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Unrecognized RecordHandler");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Unrecognized RecordHandler");
            }
        }
    }

    public String quickCreate(Object nativeItem, String schemaURL, String metadataPrefix) throws IllegalArgumentException, CannotDisseminateFormatException {
        return null;
    }

    public String fromOAIIdentifier(String identifier) {
        return identifier.substring(this.oaiIdentifierPrefix.length());
    }

    public String getDatestamp(Object nativeRec) throws IllegalArgumentException {
        return this.getDatestamp((DataDir)nativeRec);
    }

    public String getOAIIdentifier(Object nativeRec) {
        return this.getOAIIdentifier((DataDir)nativeRec);
    }

    private String getDatestamp(DataDir dir) {
        String s;
        String result = null;
        DataDir dir005 = dir.find(5);
        if (dir005 != null && (s = dir005.getString()) != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(s.substring(0, 4));
            sb.append("-");
            sb.append(s.substring(4, 6));
            sb.append("-");
            sb.append(s.substring(6, 8));
            result = sb.toString();
        }
        return result;
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        return new ArrayList().iterator();
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        return false;
    }

    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        return new ArrayList().iterator();
    }

    private String getLCCN(DataDir dir) {
        String s;
        DataDir dira;
        String result = null;
        DataDir dir010 = dir.find(10);
        if (dir010 != null && (dira = dir010.find(1)) != null && (s = dira.getString()) != null) {
            StringBuffer sb = new StringBuffer();
            if (Character.isDigit(s.charAt(2))) {
                sb.append(s.substring(0, 2).trim());
                sb.append(s.substring(2, 6));
                sb.append("-");
                int i = Integer.parseInt(s.substring(6).trim());
                sb.append(Integer.toString(i));
            } else {
                sb.append(s.substring(0, 3).trim());
                sb.append(s.substring(3, 5));
                sb.append("-");
                int i = Integer.parseInt(s.substring(5).trim());
                sb.append(Integer.toString(i));
            }
            result = sb.toString();
        }
        return result;
    }

    public String getOAIIdentifier(DataDir dir) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.oaiIdentifierPrefix);
        sb.append(this.getLCCN(dir));
        return sb.toString();
    }
}

