/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.ber.BerString;
import ORG.oclc.ber.DataDir;
import ORG.oclc.db.Db;
import ORG.oclc.db.DbUserData;
import ORG.oclc.db.PartialResults;
import ORG.oclc.log.Log;
import ORG.oclc.log.UserLog;
import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import ORG.oclc.util.IniFile;
import ORG.oclc.z39.AccessControl;
import ORG.oclc.z39.DbPresentData;
import ORG.oclc.z39.Diagnostic1;
import ORG.oclc.zbase.access.DefaultAccessClient;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class NewtonOAICatalog
extends AbstractCatalog {
    private static final boolean debug = false;
    protected IniFile iniFile;
    private static final String OCLC_BER_SYNTAX = "1.2.840.10003.5.1000.17.1";
    private Db db;
    protected static int maxListSize;
    private DbUserData dbUserData;
    private boolean readOnly;
    private boolean schemaLocationIndexed = false;
    private static String maxDate;
    protected HashMap resumptionResults = new HashMap();
    private TreeMap sets = null;
    private static Logger logger;
    static /* synthetic */ Class class$ORG$oclc$oai$server$catalog$NewtonOAICatalog;

    protected static synchronized String getRSName() {
        Date now = new Date();
        String rsName = Long.toString(now.getTime());
        logger.info((Object)("creating new RSName:" + rsName));
        return rsName;
    }

    protected void purge() {
        logger.info((Object)("NewtonOAICatalog.purge: resumptionResults.size()=" + this.resumptionResults.size()));
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            logger.info((Object)("NewtonOAICatalog.purge: resumptionResults.key=" + key));
            Date then = now;
            try {
                then = new Date(((Date)this.resumptionResults.get(key)).getTime() + (long)this.getMillisecondsToLive());
            }
            catch (Exception e) {
                logger.info((Object)("key='" + key + "', time=" + this.resumptionResults.get(key)), (Throwable)e);
            }
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            logger.info((Object)("purging old resumptionResult: key=" + key + ", date=" + this.resumptionResults.get(key)));
            this.resumptionResults.remove(key);
            try {
                this.db.deleteHitlist(key, (Object)this.dbUserData);
            }
            catch (Throwable e) {
                logger.info((Object)("deleteHitList failed for key:" + key), e);
            }
        }
    }

    public NewtonOAICatalog(Properties properties) throws IOException {
        String iniFileName = properties.getProperty("NewtonOAICatalog.inifileName");
        String maxListSize = properties.getProperty("NewtonOAICatalog.maxListSize");
        String readOnly = properties.getProperty("NewtonOAICatalog.readOnly");
        String temp = properties.getProperty("NewtonOAICatalog.schemaLocationIndexed");
        logger.debug((Object)("iniFileName=" + iniFileName));
        logger.debug((Object)("maxListSize=" + maxListSize));
        logger.debug((Object)("readOnly=" + readOnly));
        logger.debug((Object)("schemaLocationIndexed=" + temp));
        if ("true".equalsIgnoreCase(temp)) {
            this.schemaLocationIndexed = true;
        }
        if (iniFileName == null) {
            throw new FileNotFoundException("NewtonOAICatalog.inifileName is missing from the properties file");
        }
        if (maxListSize == null) {
            throw new IllegalArgumentException("NewtonOAICatalog.maxListSize is missing from the properties file");
        }
        NewtonOAICatalog.maxListSize = Integer.parseInt(maxListSize);
        if (readOnly == null) {
            throw new IllegalArgumentException("NewtonOAICatalog.readOnly is missing from the properties file");
        }
        this.readOnly = Boolean.valueOf(readOnly);
        try {
            this.iniFile = new IniFile(iniFileName);
            logger.debug((Object)("iniFile=" + this.iniFile));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Failed to open inifile");
        }
        String dbName = this.iniFile.getValue("Database", "dbName");
        logger.debug((Object)("dbName=" + dbName));
        if (dbName == null) {
            throw new FileNotFoundException("Missing Database/dbName property in " + iniFileName);
        }
        UserLog log = new UserLog();
        log.open(dbName + "user", dbName + "log", null);
        Log.out = log;
        try {
            this.db = Db.SetupDatabase((IniFile)this.iniFile, (String)"Database");
        }
        catch (Exception e) {
            logger.fatal((Object)"SetupDatabase failed", (Throwable)e);
            throw new IOException("Db.SetupDatabase failed");
        }
        this.dbUserData = (DbUserData)this.db.initDbUserData("NewtonOAICatalog", (Object)new DefaultAccessClient(), (Log)log, null);
        this.sets = NewtonOAICatalog.getSets(properties);
    }

    private static TreeMap getSets(Properties properties) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        String propertyPrefix = "Sets.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            treeMap.put(propertyName.substring(propertyPrefix.length()), properties.get(propertyName));
        }
        return treeMap;
    }

    private String normalizeTerm(String term) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(term, "-:", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("-") || token.equals(":")) {
                sb.append("\\");
                sb.append(token);
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public Map listSets() throws NoSetHierarchyException {
        if (this.sets.size() == 0) {
            throw new NoSetHierarchyException();
        }
        LinkedHashMap listSetsMap = new LinkedHashMap();
        try {
            Object[] keys = this.sets.keySet().toArray();
            Object[] values = this.sets.values().toArray();
            ArrayList<String> newList = new ArrayList<String>();
            int i = 0;
            while (i < keys.length) {
                if (((String)values[i]).indexOf("@COUNT@") != -1) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("st:");
                    sb.append(keys[i]);
                    sb.append(" and sl:\"");
                    sb.append(this.getCrosswalks().getSchemaLocation("oai_dc"));
                    sb.append("\"");
                    int postings = this.db.search(sb.toString(), "temp", true, null, false, null, (Object)this.dbUserData);
                    try {
                        this.db.deleteHitlist("temp", (Object)this.dbUserData);
                    }
                    catch (Throwable e) {
                        logger.info((Object)"deleteHitList failed for key: temp", e);
                    }
                    newList.add(((String)values[i]).replaceAll("@COUNT@", Integer.toString(postings)));
                } else {
                    newList.add((String)values[i]);
                }
                ++i;
            }
            listSetsMap.put("sets", newList.iterator());
        }
        catch (Throwable e) {
            System.err.println("NewtonOAICatalog.listSets: browse failed");
            e.printStackTrace();
        }
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException();
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        int postings;
        this.purge();
        if (set != null && set.length() > 0 && from.equals(this.toFinestFrom("0000-00-00")) && until.equals(this.toFinestUntil("9999-99-99"))) {
            from = null;
            until = null;
        }
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringBuffer query = new StringBuffer();
        String rsName = NewtonOAICatalog.getRSName();
        if (from != null && from.length() > 0 || until != null && until.length() > 0) {
            query.append("dt:");
            if (from != null && from.length() > 0) {
                query.append(this.normalizeTerm(from));
            }
            query.append("-");
            if (until != null && from.length() > 0) {
                query.append(this.normalizeTerm(until));
            }
        }
        if (set != null && set.length() > 0) {
            if (query.length() > 0) {
                query.append(" and ");
            }
            query.append("st:\"");
            query.append(this.normalizeTerm(set));
            query.append("\"");
        }
        if (this.schemaLocationIndexed) {
            query.append(" and ");
            query.append("sl:\"");
            query.append(this.getCrosswalks().getSchemaLocation(metadataPrefix));
            query.append("\"");
        }
        try {
            postings = this.db.search(query.toString(), rsName, true, null, false, null, (Object)this.dbUserData);
        }
        catch (Diagnostic1 e) {
            e.printStackTrace();
            throw new BadArgumentException();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Error");
        }
        if (postings != 0) {
            DbPresentData[] present;
            try {
                present = this.db.present(rsName, 1, maxListSize, "f", OCLC_BER_SYNTAX, (Object)this.dbUserData);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new OAIInternalServerError("Database error");
            }
            RecordFactory recordFactory = this.getRecordFactory();
            int i = 0;
            while (i < present.length) {
                BerString rec = (BerString)present[i].data;
                DataDir dir = new DataDir(rec);
                String[] header = recordFactory.createHeader((Object)dir);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++i;
            }
            if (postings > present.length) {
                StringBuffer resumptionToken = new StringBuffer();
                this.resumptionResults.put(rsName, new Date());
                resumptionToken.append(rsName);
                resumptionToken.append(":");
                resumptionToken.append(present.length);
                resumptionToken.append(":");
                resumptionToken.append(postings);
                resumptionToken.append(":");
                resumptionToken.append(metadataPrefix);
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString(), postings, 0));
            }
        } else {
            throw new NoItemsMatchException();
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int postings;
        int oldCount;
        this.purge();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        String rsName = null;
        try {
            String temp = tokenizer.nextToken();
            if (this.resumptionResults.remove(temp) == null) {
                throw new BadResumptionTokenException();
            }
            rsName = temp;
            oldCount = Integer.parseInt(tokenizer.nextToken());
            postings = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
            if (metadataPrefix.equals("null")) {
                metadataPrefix = null;
            }
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        try {
            DbPresentData[] present = this.db.present(rsName, oldCount + 1, maxListSize, "f", OCLC_BER_SYNTAX, (Object)this.dbUserData);
            RecordFactory recordFactory = this.getRecordFactory();
            int i = 0;
            while (i < present.length) {
                BerString rec = (BerString)present[i].data;
                DataDir dir = new DataDir(rec);
                String[] header = recordFactory.createHeader((Object)dir);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++i;
            }
            if (postings > oldCount + present.length) {
                String newResumptionToken = rsName + ":" + (oldCount + present.length) + ":" + postings + ":" + metadataPrefix;
                this.resumptionResults.put(rsName, new Date());
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(newResumptionToken, postings, oldCount));
            }
            listIdentifiersMap.put("headers", headers.iterator());
            listIdentifiersMap.put("identifiers", identifiers.iterator());
        }
        catch (Diagnostic1 e) {
            throw new BadResumptionTokenException();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        return listIdentifiersMap;
    }

    public Vector getSchemaLocations(String identifier) throws IdDoesNotExistException, NoMetadataFormatsException, OAIInternalServerError {
        Vector result = new Vector();
        DbPresentData[] records = null;
        try {
            records = this.getPresentData(identifier, null);
        }
        catch (Throwable e) {
            throw new OAIInternalServerError("Database failure");
        }
        if (records != null) {
            int i = 0;
            while (i < records.length) {
                DataDir dbDataDir = new DataDir((BerString)records[i].data);
                if (dbDataDir != null) {
                    Vector schemaLocations = this.getRecordFactory().getSchemaLocations((Object)dbDataDir);
                    int j = 0;
                    while (j < schemaLocations.size()) {
                        result.add(schemaLocations.get(j));
                        ++j;
                    }
                } else {
                    throw new OAIInternalServerError("Null DataDir");
                }
                ++i;
            }
        } else {
            throw new IdDoesNotExistException(identifier);
        }
        return result;
    }

    public String getRecord(String identifier, String metadataPrefix) throws IdDoesNotExistException, IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        DataDir dbDataDir;
        try {
            dbDataDir = this.getFullDataDir(identifier, metadataPrefix);
        }
        catch (Diagnostic1 e) {
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        logger.debug((Object)("dbDataDir=" + dbDataDir));
        if (dbDataDir != null) {
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                logger.info((Object)("metadataPrefix not found:" + metadataPrefix));
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            try {
                String s = this.getRecordFactory().create((Object)dbDataDir, schemaURL, metadataPrefix);
                logger.debug((Object)("s=" + s));
                return s;
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new IdDoesNotExistException(identifier);
    }

    public String getMetadata(String identifier, String metadataPrefix) throws IdDoesNotExistException, IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        DataDir dbDataDir;
        try {
            dbDataDir = this.getFullDataDir(identifier, metadataPrefix);
        }
        catch (Diagnostic1 e) {
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        if (dbDataDir != null) {
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            try {
                return this.getRecordFactory().createMetadata((Object)dbDataDir, schemaURL, metadataPrefix);
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new IdDoesNotExistException(identifier);
    }

    private DbPresentData[] getPresentData(String identifier, String metadataPrefix) throws Exception, Diagnostic1, AccessControl, PartialResults {
        int postings;
        DbPresentData[] result = null;
        String rsName = "temp";
        StringBuffer sb = new StringBuffer();
        StringBuffer query = new StringBuffer();
        query.append("id:\"");
        query.append(this.getRecordFactory().fromOAIIdentifier(identifier));
        query.append("\"");
        if (this.schemaLocationIndexed && metadataPrefix != null) {
            query.append(" and ");
            query.append("sl:\"");
            query.append(this.getCrosswalks().getSchemaLocation(metadataPrefix));
            query.append("\"");
        }
        if ((postings = this.db.search(query.toString(), rsName, true, null, false, null, (Object)this.dbUserData)) != 0) {
            result = this.db.present(rsName, 1, postings, "f", OCLC_BER_SYNTAX, (Object)this.dbUserData);
        }
        try {
            this.db.deleteHitlist(rsName, (Object)this.dbUserData);
        }
        catch (Throwable e) {
            logger.info((Object)("deleteHitList failed for key:" + rsName), e);
        }
        return result;
    }

    private DataDir getFullDataDir(String identifier, String metadataPrefix) throws Diagnostic1, AccessControl, PartialResults, Exception {
        DbPresentData[] records = this.getPresentData(identifier, metadataPrefix);
        if (records != null) {
            BerString rec = (BerString)records[0].data;
            return new DataDir(rec);
        }
        return null;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        int postings;
        this.purge();
        if (set != null && set.length() > 0 && from.equals(this.toFinestFrom("0000-00-00")) && until.equals(this.toFinestUntil("9999-99-99"))) {
            from = null;
            until = null;
        }
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StringBuffer query = new StringBuffer();
        String rsName = NewtonOAICatalog.getRSName();
        if (from != null && from.length() > 0 || until != null && until.length() > 0) {
            query.append("dt:");
            if (from != null && from.length() > 0) {
                query.append(this.normalizeTerm(from));
            }
            query.append("-");
            if (until != null && from.length() > 0) {
                query.append(this.normalizeTerm(until));
            }
        }
        if (set != null && set.length() > 0) {
            if (query.length() > 0) {
                query.append(" and ");
            }
            query.append("st:\"");
            query.append(this.normalizeTerm(set));
            query.append("\"");
        }
        if (this.schemaLocationIndexed) {
            query.append(" and ");
            query.append("sl:\"");
            query.append(this.getCrosswalks().getSchemaLocation(metadataPrefix));
            query.append("\"");
        }
        try {
            logger.debug((Object)("query=" + query.toString()));
            postings = this.db.search(query.toString(), rsName, true, null, false, null, (Object)this.dbUserData);
        }
        catch (Diagnostic1 e) {
            e.printStackTrace();
            throw new BadArgumentException();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Error");
        }
        if (postings != 0) {
            DbPresentData[] present;
            try {
                present = this.db.present(rsName, 1, maxListSize, "f", OCLC_BER_SYNTAX, (Object)this.dbUserData);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new OAIInternalServerError("Database error");
            }
            RecordFactory recordFactory = this.getRecordFactory();
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            int i = 0;
            while (i < present.length) {
                BerString rec = (BerString)present[i].data;
                DataDir dir = new DataDir(rec);
                records.add(recordFactory.create((Object)dir, schemaURL, metadataPrefix));
                ++i;
            }
            if (postings > present.length) {
                StringBuffer resumptionToken = new StringBuffer();
                this.resumptionResults.put(rsName, new Date());
                resumptionToken.append(rsName);
                resumptionToken.append(":");
                resumptionToken.append(present.length);
                resumptionToken.append(":");
                resumptionToken.append(postings);
                resumptionToken.append(":");
                resumptionToken.append(metadataPrefix);
                listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString(), postings, 0));
            }
        } else {
            throw new NoItemsMatchException();
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int postings;
        int oldCount;
        this.purge();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        String rsName = null;
        try {
            String temp = tokenizer.nextToken();
            if (this.resumptionResults.remove(temp) == null) {
                throw new BadResumptionTokenException();
            }
            rsName = temp;
            oldCount = Integer.parseInt(tokenizer.nextToken());
            postings = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        try {
            DbPresentData[] present = this.db.present(rsName, oldCount + 1, maxListSize, "f", OCLC_BER_SYNTAX, (Object)this.dbUserData);
            RecordFactory recordFactory = this.getRecordFactory();
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            int i = 0;
            while (i < present.length) {
                BerString rec = (BerString)present[i].data;
                DataDir dir = new DataDir(rec);
                records.add(recordFactory.create((Object)dir, schemaURL, metadataPrefix));
                ++i;
            }
            if (postings > oldCount + present.length) {
                String newResumptionToken = rsName + ":" + (oldCount + present.length) + ":" + postings + ":" + metadataPrefix;
                this.resumptionResults.put(rsName, new Date());
                listRecordsMap.put("resumptionMap", this.getResumptionMap(newResumptionToken, postings, oldCount));
            }
            listRecordsMap.put("records", records.iterator());
        }
        catch (Diagnostic1 e) {
            throw new BadResumptionTokenException();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        return listRecordsMap;
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        maxDate = ServerVerb.createResponseDate((Date)new Date());
        logger = Logger.getLogger((Class)(class$ORG$oclc$oai$server$catalog$NewtonOAICatalog == null ? (class$ORG$oclc$oai$server$catalog$NewtonOAICatalog = NewtonOAICatalog.class$("ORG.oclc.oai.server.catalog.NewtonOAICatalog")) : class$ORG$oclc$oai$server$catalog$NewtonOAICatalog));
        BasicConfigurator.configure();
    }
}

