/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.RecordHandler.MalformedRecordException;
import ORG.oclc.RecordHandler.RecordHandler;
import ORG.oclc.RecordHandler.UnrecognizedRecordHandlerException;
import ORG.oclc.ber.DataDir;
import ORG.oclc.oai.server.catalog.NewtonOAICatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import ORG.oclc.pears.util.FragmentFile;
import ORG.oclc.pears.util.FreespaceFile;
import ORG.oclc.pears.util.HedrFile;
import ORG.oclc.pears.util.MissingParameterException;
import ORG.oclc.util.IllegalParameterException;
import ORG.oclc.util.IniFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class QuickNewtonOAICatalog
extends NewtonOAICatalog {
    private static final boolean debug = false;
    private String minDate;
    private static String maxDate = ServerVerb.createResponseDate((Date)new Date());
    private String pdbFileList;
    private static Logger logger = Logger.getLogger((Class)(class$ORG$oclc$oai$server$catalog$NewtonOAICatalog == null ? (class$ORG$oclc$oai$server$catalog$NewtonOAICatalog = QuickNewtonOAICatalog.class$("ORG.oclc.oai.server.catalog.NewtonOAICatalog")) : class$ORG$oclc$oai$server$catalog$NewtonOAICatalog));
    static /* synthetic */ Class class$ORG$oclc$oai$server$catalog$NewtonOAICatalog;

    public QuickNewtonOAICatalog(Properties properties) throws IOException {
        super(properties);
        String minDate = properties.getProperty("Identify.earliestDatestamp");
        if (minDate == null) {
            throw new IllegalArgumentException("Identify.earliestDatestamp is missing from the properties file");
        }
        this.minDate = minDate;
        this.pdbFileList = this.iniFile.getValue("database", "parts");
    }

    protected static String getRSName(int offset) {
        StringBuffer sb = new StringBuffer();
        sb.append(NewtonOAICatalog.getRSName());
        sb.append(":");
        sb.append(offset);
        return sb.toString();
    }

    protected void purge() {
        logger.info((Object)("QuickNewtonOAICatalog.purge: resumptionResults.size()=" + this.resumptionResults.size()));
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            logger.info((Object)("QuickNewtonOAICatalog.purge: resumptionResults.key=" + key));
            Date then = now;
            try {
                then = new Date(Long.parseLong(key.split(":", 2)[0]) + (long)this.getMillisecondsToLive());
            }
            catch (Exception e) {
                logger.info((Object)("key='" + key + "', time=" + then), (Throwable)e);
            }
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            logger.info((Object)("purging old resumptionResult: key=" + key));
            this.resumptionResults.remove(key);
        }
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        this.purge();
        if (!(from != null && from.length() != 0 && from.compareTo(this.minDate) > 0 || until != null && until.length() != 0 && until.compareTo(maxDate) < 0 || set != null && set.length() != 0)) {
            return this.quickListIdentifiers(metadataPrefix, 0);
        }
        return super.listIdentifiers(from, until, set, metadataPrefix);
    }

    /*
     * WARNING - void declaration
     */
    private Map quickListIdentifiers(String metadataPrefix, int skipCount) throws CannotDisseminateFormatException, NoItemsMatchException, OAIInternalServerError {
        MultiRecordHandler mrh;
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        int i = 0;
        try {
            DataDir dir;
            mrh = new MultiRecordHandler(this.pdbFileList, skipCount);
            RecordFactory recordFactory = this.getRecordFactory();
            i = 0;
            while (i < NewtonOAICatalog.maxListSize && (dir = mrh.getNextRecord()) != null) {
                void var8_10;
                String[] header = recordFactory.createHeader((Object)var8_10);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++i;
            }
        }
        catch (IllegalParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (UnrecognizedRecordHandlerException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MalformedRecordException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        if (i == 0) {
            throw new NoItemsMatchException();
        }
        if (i == NewtonOAICatalog.maxListSize) {
            StringBuffer resumptionToken = new StringBuffer();
            String rsName = QuickNewtonOAICatalog.getRSName(i + skipCount);
            this.resumptionResults.put(rsName, mrh);
            resumptionToken.append("quick:");
            resumptionToken.append(rsName);
            resumptionToken.append(":");
            resumptionToken.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString(), -1, -1));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    /*
     * WARNING - void declaration
     */
    private Map quickListIdentifiersResume(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        String rsName;
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        int count = 0;
        try {
            String quick = tokenizer.nextToken();
            String superRSName = tokenizer.nextToken();
            count = Integer.parseInt(tokenizer.nextToken());
            rsName = superRSName + ":" + count;
            metadataPrefix = tokenizer.nextToken();
            if (metadataPrefix.equals("null")) {
                metadataPrefix = null;
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        MultiRecordHandler mrh = (MultiRecordHandler)this.resumptionResults.remove(rsName);
        if (mrh == null) {
            System.out.print("Attempt to reuse obsolete resumptionToken? ");
            System.out.println(resumptionToken);
            try {
                return this.quickListIdentifiers(metadataPrefix, count);
            }
            catch (NoItemsMatchException e) {
                e.printStackTrace();
                throw new BadResumptionTokenException();
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw new BadResumptionTokenException();
            }
        }
        int i = 0;
        try {
            DataDir dir;
            RecordFactory recordFactory = this.getRecordFactory();
            i = 0;
            while (i < NewtonOAICatalog.maxListSize && (dir = mrh.getNextRecord()) != null) {
                void e;
                String[] header = recordFactory.createHeader((Object)e);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++i;
            }
        }
        catch (IllegalParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MalformedRecordException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (UnrecognizedRecordHandlerException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        if (i == NewtonOAICatalog.maxListSize) {
            rsName = QuickNewtonOAICatalog.getRSName(count + i);
            StringBuffer resumptionTokenSb = new StringBuffer();
            this.resumptionResults.put(rsName, mrh);
            resumptionTokenSb.append("quick:");
            resumptionTokenSb.append(rsName);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, -1));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            String quickToken = tokenizer.nextToken();
            if (quickToken.equals("quick")) {
                return this.quickListIdentifiersResume(resumptionToken);
            }
            return super.listIdentifiers(resumptionToken);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        this.purge();
        if (!(from != null && from.length() != 0 && from.compareTo(this.minDate) > 0 || until != null && until.length() != 0 && until.compareTo(maxDate) < 0 || set != null && set.length() != 0)) {
            return this.quickListRecords(metadataPrefix, 0);
        }
        return super.listRecords(from, until, set, metadataPrefix);
    }

    /*
     * WARNING - void declaration
     */
    private Map quickListRecords(String metadataPrefix, int skipCount) throws CannotDisseminateFormatException, NoItemsMatchException, OAIInternalServerError {
        MultiRecordHandler mrh;
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        int i = 0;
        try {
            DataDir dir;
            mrh = new MultiRecordHandler(this.pdbFileList, skipCount);
            RecordFactory recordFactory = this.getRecordFactory();
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            i = 0;
            while (i < NewtonOAICatalog.maxListSize && (dir = mrh.getNextRecord()) != null) {
                void var7_11;
                records.add(recordFactory.create((Object)var7_11, schemaURL, metadataPrefix));
                ++i;
            }
        }
        catch (IllegalParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (UnrecognizedRecordHandlerException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MalformedRecordException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        if (i == 0) {
            throw new NoItemsMatchException();
        }
        if (i == NewtonOAICatalog.maxListSize) {
            StringBuffer resumptionToken = new StringBuffer();
            String rsName = QuickNewtonOAICatalog.getRSName(i + skipCount);
            this.resumptionResults.put(rsName, mrh);
            resumptionToken.append("quick:");
            resumptionToken.append(rsName);
            resumptionToken.append(":");
            resumptionToken.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString(), -1, -1));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            String quickToken = tokenizer.nextToken();
            if (quickToken.equals("quick")) {
                return this.quickListRecordsResume(resumptionToken);
            }
            return super.listRecords(resumptionToken);
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map quickListRecordsResume(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        String rsName;
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        int count = 0;
        try {
            String quick = tokenizer.nextToken();
            String superRSName = tokenizer.nextToken();
            count = Integer.parseInt(tokenizer.nextToken());
            rsName = superRSName + ":" + count;
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        MultiRecordHandler mrh = (MultiRecordHandler)this.resumptionResults.remove(rsName);
        if (mrh == null) {
            System.out.print("Attempt to reuse resumptionToken? ");
            System.out.println(resumptionToken);
            try {
                return this.quickListRecords(metadataPrefix, count);
            }
            catch (NoItemsMatchException e) {
                e.printStackTrace();
                throw new BadResumptionTokenException();
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw new BadResumptionTokenException();
            }
        }
        int i = 0;
        try {
            DataDir dir;
            RecordFactory recordFactory = this.getRecordFactory();
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                System.out.println("QuickNewtonOAICatalog.quickListRecordsResume: bad metadataPrefix=" + metadataPrefix);
                throw new BadResumptionTokenException();
            }
            i = 0;
            while (i < NewtonOAICatalog.maxListSize && (dir = mrh.getNextRecord()) != null) {
                void e;
                records.add(recordFactory.create((Object)e, schemaURL, metadataPrefix));
                ++i;
            }
        }
        catch (IllegalParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (UnrecognizedRecordHandlerException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (MalformedRecordException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (CannotDisseminateFormatException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
        if (i == NewtonOAICatalog.maxListSize) {
            StringBuffer resumptionTokenSb = new StringBuffer();
            rsName = QuickNewtonOAICatalog.getRSName(count + i);
            this.resumptionResults.put(rsName, mrh);
            resumptionTokenSb.append("quick:");
            resumptionTokenSb.append(rsName);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, -1));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BasicConfigurator.configure();
    }

    public class MultiRecordHandler {
        private StringTokenizer pdbFileList;
        private RecordHandler rh;

        public MultiRecordHandler(String pdbFileList, int skipCount) throws IOException, UnrecognizedRecordHandlerException, MalformedRecordException, IllegalParameterException, MissingParameterException {
            String pdbFileName;
            int current = 0;
            int previous = 0;
            this.pdbFileList = new StringTokenizer(pdbFileList);
            do {
                previous += current;
                this.rh = RecordHandler.getHandler((String)"PDB");
                String token = this.pdbFileList.nextToken();
                IniFile iniFile = new IniFile(token);
                pdbFileName = iniFile.getValue("database", "pdbFile");
                StringReader sr = new StringReader("[HandlePDB]\ncharconverter=UTF-8\nignoreRecoverableErrors=true\n");
                IniFile rhIni = new IniFile((Reader)sr);
                this.rh.Input(pdbFileName, rhIni);
            } while (previous + (current = this.numRecords(pdbFileName)) <= skipCount);
            while (previous++ < skipCount) {
                this.rh.loadRecord();
            }
        }

        private int numRecords(String pdbFileName) throws IOException {
            FreespaceFile fsf = new FreespaceFile(pdbFileName);
            if (!fsf.OK()) {
                throw new IOException("Unable to open FreespaceFile");
            }
            FragmentFile ff = new FragmentFile(fsf);
            HedrFile hf = new HedrFile(ff);
            int numRecs = hf.getNumRecs();
            return numRecs;
        }

        public byte[] loadRecord() throws EOFException, UnrecognizedRecordHandlerException, IOException, MalformedRecordException, IllegalParameterException, MissingParameterException {
            byte[] bytes = null;
            try {
                while ((bytes = this.rh.loadRecord()) == null) {
                    if (this.pdbFileList.hasMoreTokens()) {
                        this.rh = RecordHandler.getHandler((String)"PDB");
                        StringReader sr = new StringReader("[HandlePDB]\ncharconverter=UTF-8\nignoreRecoverableErrors=true\n");
                        IniFile rhIni = new IniFile((Reader)sr);
                        String token = this.pdbFileList.nextToken();
                        IniFile iniFile = new IniFile(token);
                        this.rh.Input(iniFile.getValue("database", "pdbFile"), rhIni);
                        continue;
                    }
                    return null;
                }
            }
            catch (EOFException e) {
                return null;
            }
            return bytes;
        }

        public DataDir getNextRecord() throws IOException, MalformedRecordException, UnrecognizedRecordHandlerException, MissingParameterException, IllegalParameterException {
            DataDir dir = null;
            while ((dir = this.rh.getNextRecord()) == null) {
                if (this.pdbFileList.hasMoreTokens()) {
                    this.rh = RecordHandler.getHandler((String)"PDB");
                    StringReader sr = new StringReader("[HandlePDB]\ncharconverter=UTF-8\nignoreRecoverableErrors=true\n");
                    IniFile rhIni = new IniFile((Reader)sr);
                    String token = this.pdbFileList.nextToken();
                    IniFile iniFile = new IniFile(token);
                    this.rh.Input(iniFile.getValue("database", "pdbFile"), rhIni);
                    continue;
                }
                return null;
            }
            return dir;
        }
    }
}

