/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.RecordHandler.HandleSGML;
import ORG.oclc.RecordHandler.MalformedRecordException;
import ORG.oclc.RecordHandler.RecordHandler;
import ORG.oclc.RecordHandler.UnrecognizedRecordHandlerException;
import ORG.oclc.ber.DataDir;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.pears.util.MissingParameterException;
import ORG.oclc.util.IllegalParameterException;
import ORG.oclc.util.IniFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class XMLDataDirRecordFactory
extends RecordFactory {
    private static boolean debug = false;
    private static HandleSGML recordHandler = null;
    private static final String metadataStart = "<metadata>";
    private static final String metadataEnd = "</metadata>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] fromDataDir(DataDir dir) throws MalformedRecordException {
        HandleSGML handleSGML = recordHandler;
        synchronized (handleSGML) {
            if (debug) {
                System.out.println("XMLDataDirRecordFactory.fromDataDir: dir=" + dir);
            }
            return recordHandler.fromDataDir(dir);
        }
    }

    public XMLDataDirRecordFactory(Properties properties) throws IllegalArgumentException {
        super(properties);
        if (recordHandler == null) {
            String htmlEncode = properties.getProperty("XMLDataDirRecordFactory.htmlEncode", "");
            String tagsFileName = properties.getProperty("XMLDataDirRecordFactory.tagsFileName");
            if (tagsFileName == null) {
                throw new IllegalArgumentException("XMLDataDirRecordfactory.tagsfilename is missing from properties file");
            }
            try {
                recordHandler = (HandleSGML)RecordHandler.getHandler((String)"SGML");
                StringReader sr = new StringReader("[HandleSGML]\ncharconverter=UTF-8\n" + htmlEncode + "tagsfile=" + tagsFileName + "\n" + "ignoreRecoverableErrors=true\n");
                IniFile rhIni = new IniFile((Reader)sr);
                recordHandler.Input((InputStream)null, rhIni);
            }
            catch (MissingParameterException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Unrecognized RecordHandler");
            }
            catch (IllegalParameterException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Unrecognized RecordHandler");
            }
            catch (UnrecognizedRecordHandlerException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Unrecognized RecordHandler");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("IOException occurred");
            }
        }
    }

    public String quickCreate(Object nativeItem, String schemaURL, String metadataPrefix) throws IllegalArgumentException, CannotDisseminateFormatException {
        return null;
    }

    public String fromOAIIdentifier(String identifier) {
        return identifier;
    }

    public String getDatestamp(Object nativeItem) throws IllegalArgumentException {
        DataDir dir = (DataDir)nativeItem;
        return dir.find(10).find(12).find(1).getUTFString();
    }

    protected String getOAIIdentifier(Object nativeItem) throws IllegalArgumentException {
        DataDir dir = (DataDir)nativeItem;
        return dir.find(10).find(11).find(1).getUTFString();
    }

    public Iterator getSetSpecs(Object nativeItem) throws IllegalArgumentException {
        ArrayList<String> list = new ArrayList<String>();
        DataDir dir = (DataDir)nativeItem;
        DataDir dir10 = dir.find(10);
        DataDir dir38 = dir10.find(38);
        while (dir38 != null) {
            list.add(dir38.find(1).getUTFString());
            dir38 = dir10.findNext(38, (int)dir38.asn1class());
        }
        return list.iterator();
    }

    public boolean isDeleted(Object nativeItem) throws IllegalArgumentException {
        DataDir dir = (DataDir)nativeItem;
        return (dir = dir.find(10).find(2)) != null && (dir = dir.find(39)) != null && "deleted".equals(dir.getUTFString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
        DataDir dir = (DataDir)nativeItem;
        DataDir dir40 = dir.find(40);
        ArrayList<String> list = new ArrayList<String>();
        while (dir40 != null) {
            try {
                HandleSGML handleSGML = recordHandler;
                synchronized (handleSGML) {
                    list.add(new String(recordHandler.fromDataDir(dir40.child()), "UTF8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("UnsupportedEncodingException");
            }
            catch (MalformedRecordException e) {
                throw new IllegalArgumentException("MalformedRecordException");
            }
            dir40 = dir.findNext(40, (int)dir40.asn1class());
        }
        return list.iterator();
    }
}

