/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.crosswalk;

import ORG.oclc.oai.harvester.crosswalk.Crosswalk;
import ORG.oclc.oai.harvester.verb.CannotCrosswalkFormatException;
import ORG.oclc.oai.harvester.verb.Record;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XSLTCrosswalk
extends Crosswalk {
    private Transformer transformer;

    public XSLTCrosswalk(Properties properties) throws IllegalArgumentException {
        block2: {
            super(properties.getProperty("XSLTCrosswalk.schemaLocation"));
            this.transformer = null;
            String xsltPath = properties.getProperty("XSLTCrosswalk.xsltPath");
            if (xsltPath == null) break block2;
            try {
                StreamSource xslSource = new StreamSource(new FileInputStream(xsltPath));
                TransformerFactory tFactory = TransformerFactory.newInstance();
                this.transformer = tFactory.newTransformer(xslSource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isAvailableFor(Record record) {
        return true;
    }

    public Object toItem(Record record) throws CannotCrosswalkFormatException {
        String xmlRec = record.getMetadata();
        if (this.transformer == null) {
            return xmlRec;
        }
        if (xmlRec.startsWith("<?")) {
            int offset = xmlRec.indexOf("?>");
            xmlRec = xmlRec.substring(offset + 2);
        }
        StringReader stringReader = new StringReader(xmlRec);
        StreamSource streamSource = new StreamSource(stringReader);
        StringWriter stringWriter = new StringWriter();
        try {
            this.transformer.transform(streamSource, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new CannotCrosswalkFormatException();
        }
    }
}

