/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.HarvesterVerb;
import ORG.oclc.oai.harvester.verb.Record;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ListRecords
extends HarvesterVerb {
    private static final boolean debug = false;
    private boolean resumptionTokenCapture = false;
    private StringBuffer resumptionToken = new StringBuffer();
    private boolean recordCapture = false;
    private StringBuffer record = new StringBuffer();
    private ArrayList records = new ArrayList();

    public ListRecords(URL baseURL, String from, String until, String set, String metadataPrefix) throws MalformedURLException, SAXException, IOException {
        StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(ListRecords.getParams(from, until, set, metadataPrefix));
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + query);
            e.printStackTrace();
            throw e;
        }
    }

    public ListRecords(URL baseURL, String resumptionToken) throws MalformedURLException, SAXException, IOException {
        StringBuffer query = new StringBuffer();
        query.append(baseURL.toString());
        query.append("?");
        query.append(ListRecords.getParams(resumptionToken));
        Object eCopy = null;
        XMLReader xmlReader = this.getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        xmlReader.setContentHandler(this);
        try {
            xmlReader.parse(new InputSource(this.getResponseStream(query.toString())));
        }
        catch (SAXException e) {
            System.out.println("HarvesterVerb.HarvesterVerb: query=" + query);
            e.printStackTrace();
            throw e;
        }
    }

    private static String getParams(String from, String until, String set, String metadataPrefix) throws IOException {
        try {
            StringBuffer query = new StringBuffer();
            query.append("verb=ListRecords");
            if (until != null && until.length() != 0) {
                query.append("&until=");
                query.append(URLEncoder.encode(until, "UTF-8"));
            }
            if (from != null && from.length() != 0) {
                query.append("&from=");
                query.append(URLEncoder.encode(from, "UTF-8"));
            }
            if (set != null && set.length() != 0) {
                query.append("&set=");
                query.append(URLEncoder.encode(set, "UTF-8"));
            }
            query.append("&metadataPrefix=");
            query.append(URLEncoder.encode(metadataPrefix, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private static String getParams(String resumptionToken) throws IOException {
        try {
            StringBuffer query = new StringBuffer();
            query.append("verb=ListRecords");
            query.append("&resumptionToken=");
            query.append(URLEncoder.encode(resumptionToken, "UTF-8"));
            return query.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public Iterator iterator() {
        return this.records.iterator();
    }

    public String getResumptionToken() {
        if (this.resumptionToken.length() == 0) {
            return null;
        }
        return this.resumptionToken.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("resumptionToken: ");
        sb.append(this.resumptionToken);
        sb.append("\n");
        sb.append(super.toString());
        return sb.toString();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (!this.recordCapture && fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            this.record.setLength(0);
            this.recordCapture = true;
        }
        if (this.recordCapture) {
            this.record.append("<");
            this.record.append(qName);
            int length = attrs.getLength();
            int i = 0;
            while (i < length) {
                this.record.append(" ");
                String aEName = attrs.getQName(i);
                this.record.append(aEName);
                this.record.append("=\"");
                this.record.append(OAIUtil.xmlEncode(attrs.getValue(i)));
                this.record.append("\"");
                ++i;
            }
            this.record.append(">");
        } else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = true;
        } else {
            super.startElement(namespaceURI, localName, qName, attrs);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (this.recordCapture) {
            this.record.append("</");
            this.record.append(qName);
            this.record.append(">");
        } else if (!this.resumptionTokenCapture) {
            super.endElement(namespaceURI, localName, qName);
        }
        if (fullName.equals(HarvesterVerb.OAI20_RECORD)) {
            try {
                this.records.add(new Record(this.record.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new SAXException(e.getMessage());
            }
            this.recordCapture = false;
        } else if (fullName.equals(HarvesterVerb.OAI20_RESUMPTION_TOKEN)) {
            this.resumptionTokenCapture = false;
        }
    }

    public void characters(char[] buf, int offset, int len) {
        if (this.resumptionTokenCapture) {
            this.resumptionToken.append(new String(buf, offset, len));
        } else if (this.recordCapture) {
            this.record.append(OAIUtil.xmlEncode(new String(buf, offset, len)));
        } else {
            super.characters(buf, offset, len);
        }
    }
}

