/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtil {
    private static final boolean debug = false;
    private DocumentBuilder parser;

    public XMLUtil() {
        this(false, false);
    }

    public XMLUtil(boolean validating, boolean namespaceAware) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        factory.setNamespaceAware(namespaceAware);
        try {
            this.parser = factory.newDocumentBuilder();
            this.parser.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException e) throws SAXException {
                    System.out.println("fatalError");
                    e.printStackTrace();
                    throw e;
                }

                public void error(SAXParseException e) throws SAXParseException {
                    System.out.println("error");
                    e.printStackTrace();
                    throw e;
                }

                public void warning(SAXParseException e) throws SAXParseException {
                    System.out.println("warning");
                    e.printStackTrace();
                    System.out.println("** Warning, line" + e.getLineNumber() + ", uri " + e.getSystemId());
                    System.out.println(" " + e.getMessage());
                }
            });
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace(System.err);
        }
    }

    public Document newDocument() {
        return this.parser.newDocument();
    }

    public Document parse(String uri) throws SAXException, IOException {
        URL url = new URL(uri);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/1.1");
            try {
                responseCode = con.getResponseCode();
            }
            catch (FileNotFoundException e) {
                responseCode = 503;
            }
            if (responseCode != 503) continue;
            long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
            if (retrySeconds == -1L) {
                long now = new Date().getTime();
                long retryDate = con.getHeaderFieldDate("Retry-After", now);
                retrySeconds = retryDate - now;
            }
            if (retrySeconds == 0L) {
                throw new FileNotFoundException("Bad URL?");
            }
            System.err.println("Server response: Retry-After=" + retrySeconds);
            if (retrySeconds <= 0L) continue;
            try {
                Thread.sleep(retrySeconds * 1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } while (responseCode == 503);
        InputStream is = con.getInputStream();
        return this.parser.parse(is);
    }

    public Document parse(InputSource s) throws SAXException, IOException {
        return this.parser.parse(s);
    }

    public Document parse(InputStream s) throws SAXException, IOException {
        return this.parser.parse(s);
    }

    public Document parse(Reader r) throws SAXException, IOException {
        InputSource is = new InputSource(r);
        return this.parser.parse(is);
    }

    public static Element getElement(Document doc, String tagName) {
        return XMLUtil.getElement(doc.getDocumentElement(), tagName);
    }

    public static Element getElement(Document doc, String tagName, int index) {
        return XMLUtil.getElement(doc.getDocumentElement(), tagName, index);
    }

    public static Element getElement(Element el, String tagName) {
        return XMLUtil.getElement(el, tagName, 0);
    }

    public static Element getElement(Element el, String tagName, int index) {
        NodeList list = el.getElementsByTagName(tagName);
        return (Element)list.item(index);
    }

    public static Element getElementNS(Element el, String nameSpaceURI, String tagName) {
        return XMLUtil.getElementNS(el, nameSpaceURI, tagName, 0);
    }

    public static Element getElementNS(Element el, String nameSpaceURI, String tagName, int index) {
        NodeList list = el.getElementsByTagNameNS(nameSpaceURI, tagName);
        return (Element)list.item(index);
    }

    public static int getSize(Document doc, String tagName) {
        return XMLUtil.getSize(doc.getDocumentElement(), tagName);
    }

    public static int getSize(Element el, String tagName) {
        NodeList list = el.getElementsByTagName(tagName);
        return list.getLength();
    }

    public static int getSizeNS(Element el, String nameSpaceURI, String tagName) {
        NodeList list = el.getElementsByTagNameNS(nameSpaceURI, tagName);
        return list.getLength();
    }

    public static String getValue(Document doc, String tagName) {
        return XMLUtil.getValue(doc.getDocumentElement(), tagName);
    }

    public static String getValue(Element el, String tagName) {
        return XMLUtil.getValue(el, tagName, 0);
    }

    public static String getValue(Element el, String tagName, int index) {
        return XMLUtil.getValue(XMLUtil.getElement(el, tagName, index));
    }

    public static String getValue(Element el) {
        if (el != null) {
            NodeList nodes = el.getChildNodes();
            StringBuffer sb = new StringBuffer();
            int length = nodes.getLength();
            int i = 0;
            while (i < length) {
                Node node = nodes.item(i);
                String s = null;
                s = node.getNodeValue();
                if (s != null) {
                    sb.append(s.trim());
                }
                ++i;
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final void main(String[] args) {
        try {
            String buffer;
            URL url = new URL(args[0]);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setUseCaches(false);
            InputStream is = conn.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((buffer = br.readLine()) != null) {
                void var6_7;
                System.out.println((String)var6_7);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

