/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class AbstractCatalog {
    private static final boolean debug = false;
    private RecordFactory recordFactory;
    private boolean harvestable = true;
    private int millisecondsToLive = -1;
    private int supportedGranularityOffset = -1;
    private static final String[] VALID_GRANULARITIES = new String[]{"YYYY-MM-DD", "YYYY-MM-DDThh:mm:ssZ"};
    private static final String[] FROM_GRANULARITIES = new String[]{"0000-01-01", "0000-01-01T00:00:00Z"};
    static /* synthetic */ Class class$java$util$Properties;

    public RecordFactory getRecordFactory() {
        return this.recordFactory;
    }

    public void setHarvestable(boolean harvestable) {
        this.harvestable = harvestable;
    }

    public boolean isHarvestable() {
        return this.harvestable;
    }

    public int getMillisecondsToLive() {
        return this.millisecondsToLive;
    }

    public void setRecordFactory(RecordFactory recordFactory) {
        this.recordFactory = recordFactory;
    }

    public void setSupportedGranularityOffset(int i) {
        this.supportedGranularityOffset = i;
    }

    public String toFinestFrom(String from) throws BadArgumentException {
        if (from.length() > VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            throw new BadArgumentException();
        }
        if (from.length() != VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            StringBuffer sb = new StringBuffer(from);
            if (sb.charAt(sb.length() - 1) == 'Z') {
                sb.setLength(sb.length() - 1);
            }
            sb.append(FROM_GRANULARITIES[this.supportedGranularityOffset].substring(sb.length()));
            from = sb.toString();
        }
        if (!this.isValidGranularity(from)) {
            throw new BadArgumentException();
        }
        return from;
    }

    public String toFinestUntil(String until) throws BadArgumentException {
        if (until.length() == VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            if (!this.isValidGranularity(until)) {
                throw new BadArgumentException();
            }
            return until;
        }
        if (until.length() > VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            throw new BadArgumentException();
        }
        StringBuffer sb = new StringBuffer(until);
        if (sb.charAt(sb.length() - 1) == 'Z') {
            sb.setLength(sb.length() - 1);
        }
        if (sb.length() < VALID_GRANULARITIES[0].length()) {
            while (sb.length() < 4) {
                sb.append("9");
            }
            switch (sb.length()) {
                case 4: {
                    sb.append("-");
                }
                case 5: {
                    sb.append("12");
                }
                case 7: {
                    sb.append("-");
                }
                case 8: {
                    sb.append("31");
                    break;
                }
                case 6: 
                case 9: {
                    throw new BadArgumentException();
                }
            }
        }
        if ((until = sb.toString()).length() == VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            if (!this.isValidGranularity(until)) {
                throw new BadArgumentException();
            }
            return until;
        }
        if (sb.length() < VALID_GRANULARITIES[1].length()) {
            switch (sb.length()) {
                case 10: {
                    sb.append("T");
                }
                case 11: {
                    sb.append("23");
                }
                case 13: {
                    sb.append(":");
                }
                case 14: {
                    sb.append("59");
                }
                case 16: {
                    sb.append(":");
                }
                case 17: {
                    sb.append("59");
                }
                case 19: {
                    sb.append("Z");
                    break;
                }
                case 18: {
                    throw new BadArgumentException();
                }
            }
        }
        if (!this.isValidGranularity(until = sb.toString())) {
            throw new BadArgumentException();
        }
        return until;
    }

    private boolean isValidGranularity(String date) {
        if (date.length() > VALID_GRANULARITIES[this.supportedGranularityOffset].length()) {
            return false;
        }
        if (!(date.length() >= VALID_GRANULARITIES[0].length() && Character.isDigit(date.charAt(0)) && Character.isDigit(date.charAt(1)) && Character.isDigit(date.charAt(2)) && Character.isDigit(date.charAt(3)) && date.charAt(4) == '-' && Character.isDigit(date.charAt(5)) && Character.isDigit(date.charAt(6)) && date.charAt(7) == '-' && Character.isDigit(date.charAt(8)) && Character.isDigit(date.charAt(9)))) {
            return false;
        }
        return date.length() <= VALID_GRANULARITIES[0].length() || date.charAt(10) == 'T' && date.charAt(date.length() - 1) == 'Z' && Character.isDigit(date.charAt(11)) && Character.isDigit(date.charAt(12)) && date.charAt(13) == ':' && Character.isDigit(date.charAt(14)) && Character.isDigit(date.charAt(15)) && date.charAt(16) == ':' && Character.isDigit(date.charAt(17)) && Character.isDigit(date.charAt(18));
    }

    public Crosswalks getCrosswalks() {
        return this.recordFactory.getCrosswalks();
    }

    public abstract Map listSets() throws NoSetHierarchyException, OAIInternalServerError;

    public abstract Map listSets(String var1) throws BadResumptionTokenException, OAIInternalServerError;

    public static AbstractCatalog factory(Properties properties) throws Throwable {
        AbstractCatalog oaiCatalog = null;
        String oaiCatalogClassName = properties.getProperty("AbstractCatalog.oaiCatalogClassName");
        String recordFactoryClassName = properties.getProperty("AbstractCatalog.recordFactoryClassName");
        if (oaiCatalogClassName == null) {
            throw new ClassNotFoundException("AbstractCatalog.oaiCatalogClassName is missing from properties file");
        }
        if (recordFactoryClassName == null) {
            throw new ClassNotFoundException("AbstractCatalog.recordFactoryClassName is missing from properties file");
        }
        Class<?> oaiCatalogClass = Class.forName(oaiCatalogClassName);
        Constructor<?> oaiCatalogConstructor = oaiCatalogClass.getConstructor(class$java$util$Properties == null ? (class$java$util$Properties = AbstractCatalog.class$("java.util.Properties")) : class$java$util$Properties);
        try {
            String secondsToLive;
            oaiCatalog = (AbstractCatalog)oaiCatalogConstructor.newInstance(properties);
            Class<?> recordFactoryClass = Class.forName(recordFactoryClassName);
            Constructor<?> recordFactoryConstructor = recordFactoryClass.getConstructor(class$java$util$Properties == null ? (class$java$util$Properties = AbstractCatalog.class$("java.util.Properties")) : class$java$util$Properties);
            oaiCatalog.recordFactory = (RecordFactory)recordFactoryConstructor.newInstance(properties);
            String harvestable = properties.getProperty("AbstractCatalog.harvestable");
            if (harvestable != null && harvestable.equals("false")) {
                oaiCatalog.harvestable = false;
            }
            if ((secondsToLive = properties.getProperty("AbstractCatalog.secondsToLive")) != null) {
                oaiCatalog.millisecondsToLive = Integer.parseInt(secondsToLive) * 1000;
            }
            String granularity = properties.getProperty("AbstractCatalog.granularity");
            int i = 0;
            while (granularity != null && i < VALID_GRANULARITIES.length) {
                if (granularity.equalsIgnoreCase(VALID_GRANULARITIES[i])) {
                    oaiCatalog.supportedGranularityOffset = i;
                    break;
                }
                ++i;
            }
            if (oaiCatalog.supportedGranularityOffset == -1) {
                oaiCatalog.supportedGranularityOffset = 0;
                System.err.println("AbstractCatalog.factory: Invalid or missing AbstractCatalog.granularity property. Setting value to default: " + VALID_GRANULARITIES[oaiCatalog.supportedGranularityOffset]);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        return oaiCatalog;
    }

    public abstract Vector getSchemaLocations(String var1) throws IdDoesNotExistException, NoMetadataFormatsException, OAIInternalServerError;

    public abstract Map listIdentifiers(String var1, String var2, String var3, String var4) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError;

    public abstract Map listIdentifiers(String var1) throws BadResumptionTokenException, OAIInternalServerError;

    public abstract String getRecord(String var1, String var2) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError;

    public String getMetadata(String identifier, String metadataPrefix) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        throw new OAIInternalServerError("You need to override AbstractCatalog.getMetadata()");
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        Map listIdentifiersMap = this.listIdentifiers(from, until, set, metadataPrefix);
        String resumptionToken = (String)listIdentifiersMap.get("resumptionToken");
        Iterator identifiers = (Iterator)listIdentifiersMap.get("identifiers");
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        while (identifiers.hasNext()) {
            String identifier = (String)identifiers.next();
            try {
                records.add(this.getRecord(identifier, metadataPrefix));
            }
            catch (IdDoesNotExistException e) {
                throw new OAIInternalServerError("GetRecord failed to retrieve identifier '" + identifier + "'");
            }
        }
        listRecordsMap.put("records", records.iterator());
        if (resumptionToken != null) {
            listRecordsMap.put("resumptionToken", resumptionToken);
        }
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        Map listIdentifiersMap = this.listIdentifiers(resumptionToken);
        resumptionToken = (String)listIdentifiersMap.get("resumptionToken");
        Iterator identifiers = (Iterator)listIdentifiersMap.get("identifiers");
        String metadataPrefix = (String)listIdentifiersMap.get("metadataPrefix");
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        while (identifiers.hasNext()) {
            String identifier = (String)identifiers.next();
            try {
                records.add(this.getRecord(identifier, metadataPrefix));
            }
            catch (IdDoesNotExistException e) {
                throw new OAIInternalServerError("GetRecord failed to retrieve identifier '" + identifier + "'");
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
        }
        listRecordsMap.put("records", records.iterator());
        if (resumptionToken != null) {
            listRecordsMap.put("resumptionToken", resumptionToken);
        }
        return listRecordsMap;
    }

    public Map getResumptionMap(String resumptionToken) {
        return this.getResumptionMap(resumptionToken, -1, -1);
    }

    public Map getResumptionMap(String resumptionToken, int completeListSize, int cursor) {
        HashMap<String, String> resumptionMap = null;
        if (resumptionToken != null) {
            resumptionMap = new HashMap<String, String>();
            resumptionMap.put("resumptionToken", resumptionToken);
            if (this.millisecondsToLive > 0) {
                Date now = new Date();
                Date then = new Date(new Date().getTime() + (long)this.millisecondsToLive);
                resumptionMap.put("expirationDate", ServerVerb.createResponseDate(then));
            }
            if (completeListSize >= 0) {
                resumptionMap.put("completeListSize", Integer.toString(completeListSize));
            }
            if (cursor >= 0) {
                resumptionMap.put("cursor", Integer.toString(cursor));
            }
        }
        return resumptionMap;
    }

    public abstract void close();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

