/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class FileSystemOAICatalog
extends AbstractCatalog {
    static final boolean debug = false;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat();
    protected String homeDir;
    private HashMap fileDateMap = new HashMap();
    private HashMap resumptionResults = new HashMap();
    private int maxListSize;
    private boolean hideExtension = false;

    public FileSystemOAICatalog(Properties properties) throws IOException {
        this.dateFormatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String temp = properties.getProperty("FileSystemOAICatalog.maxListSize");
        if (temp == null) {
            throw new IllegalArgumentException("FileSystemOAICatalog.maxListSize is missing from the properties file");
        }
        this.maxListSize = Integer.parseInt(temp);
        this.hideExtension = "true".equalsIgnoreCase(properties.getProperty("FileSystemOAICatalog.hideExtension"));
        this.homeDir = properties.getProperty("FileSystemOAICatalog.homeDir");
        if (this.homeDir == null) {
            throw new IllegalArgumentException("FileSystemOAICatalog.homeDir is missing from the properties file");
        }
        File homeFile = new File(this.homeDir);
        int homeDirLen = homeFile.getPath().length() + 1;
        this.loadFileMap(homeDirLen, homeFile);
    }

    private void loadFileMap(int homeDirLen, File currentDir) {
        String[] list = currentDir.list();
        int i = 0;
        while (i < list.length) {
            File child = new File(currentDir, list[i]);
            if (child.isDirectory()) {
                this.loadFileMap(homeDirLen, child);
            } else if (this.isMetadataFile(child)) {
                String localIdentifier = this.file2LocalIdentifier(homeDirLen, child);
                String datestamp = this.date2OAIDatestamp(new Date(child.lastModified()));
                this.fileDateMap.put(localIdentifier, datestamp);
            }
            ++i;
        }
    }

    protected boolean isMetadataFile(File child) {
        return true;
    }

    protected String file2LocalIdentifier(int homeDirLen, File file) {
        String fileName = file.getPath().substring(homeDirLen).replace(File.separatorChar, '/');
        if (this.hideExtension && fileName.endsWith(".xml")) {
            fileName = fileName.substring(0, fileName.lastIndexOf(".xml"));
        }
        return fileName;
    }

    protected File localIdentifier2File(String localIdentifier) {
        String fileName = localIdentifier.replace('/', File.separatorChar);
        if (this.hideExtension) {
            fileName = fileName + ".xml";
        }
        return new File(this.homeDir, fileName);
    }

    private String date2OAIDatestamp(Date date) {
        return this.dateFormatter.format(date);
    }

    private HashMap getNativeHeader(String localIdentifier) throws IOException {
        HashMap<String, String> recordMap = null;
        if (this.fileDateMap.containsKey(localIdentifier)) {
            recordMap = new HashMap<String, String>();
            recordMap.put("localIdentifier", localIdentifier);
            recordMap.put("lastModified", (String)this.fileDateMap.get(localIdentifier));
            return recordMap;
        }
        return recordMap;
    }

    private HashMap getNativeRecord(String localIdentifier) throws IOException {
        HashMap recordMap = this.getNativeHeader(localIdentifier);
        if (recordMap == null) {
            return null;
        }
        File file = this.localIdentifier2File(localIdentifier);
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] buffer = new byte[(int)file.length()];
            bis.read(buffer, 0, (int)file.length());
            recordMap.put("recordBytes", buffer);
            return recordMap;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        HashMap nativeItem = null;
        try {
            String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
            nativeItem = this.getNativeRecord(localIdentifier);
            if (nativeItem == null) {
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            return this.constructRecord(nativeItem, metadataPrefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws IdDoesNotExistException, OAIInternalServerError, NoMetadataFormatsException {
        HashMap nativeItem = null;
        try {
            String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
            nativeItem = this.getNativeRecord(localIdentifier);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        if (nativeItem != null) {
            return this.getRecordFactory().getSchemaLocations(nativeItem);
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Iterator iterator = this.fileDateMap.entrySet().iterator();
        int numRows = this.fileDateMap.entrySet().size();
        int count = 0;
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String fileDate = (String)entryDateMap.getValue();
            if (fileDate.compareTo(from) < 0 || fileDate.compareTo(until) > 0) continue;
            try {
                HashMap nativeHeader = this.getNativeHeader((String)entryDateMap.getKey());
                String[] header = this.getRecordFactory().createHeader(nativeHeader);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = FileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        int count;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("FileSystemOAICatalog.listIdentifiers: reuse of old resumptionToken?");
            iterator = this.fileDateMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry entryDateMap = iterator.next();
            try {
                HashMap nativeHeader = this.getNativeHeader((String)entryDateMap.getKey());
                String[] header = this.getRecordFactory().createHeader(nativeHeader);
                headers.add(header[0]);
                identifiers.add(header[1]);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (iterator.hasNext()) {
            resumptionId = FileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    private String constructRecord(HashMap nativeItem, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        Iterator abouts = this.getAbouts(nativeItem);
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        return this.getRecordFactory().create(nativeItem, schemaURL, metadataPrefix, setSpecs, abouts);
    }

    private Iterator getSetSpecs(HashMap nativeItem) throws OAIInternalServerError {
        return null;
    }

    private Iterator getAbouts(HashMap nativeItem) throws OAIInternalServerError {
        return null;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        Iterator iterator = this.fileDateMap.entrySet().iterator();
        int numRows = this.fileDateMap.entrySet().size();
        int count = 0;
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String fileDate = (String)entryDateMap.getValue();
            if (fileDate.compareTo(from) < 0 || fileDate.compareTo(until) > 0) continue;
            try {
                HashMap nativeItem = this.getNativeRecord((String)entryDateMap.getKey());
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                ++count;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = FileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        int count;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("FileSystemOAICatalog.listRecords: reuse of old resumptionToken?");
            iterator = this.fileDateMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry entryDateMap = iterator.next();
            try {
                HashMap nativeItem = this.getNativeRecord((String)entryDateMap.getKey());
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                continue;
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
            catch (IOException e) {
                throw new BadResumptionTokenException();
            }
        }
        if (iterator.hasNext()) {
            resumptionId = FileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listSets() throws OAIInternalServerError, NoSetHierarchyException {
        throw new NoSetHierarchyException();
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        throw new BadResumptionTokenException();
    }

    public void close() {
    }

    private void purge() {
        String key;
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getRSName() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }
}

