/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.util.OAIUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class JDBCLimitedOAICatalog
extends AbstractCatalog {
    private static final boolean debug = true;
    private String identifierQuery = null;
    private String rangeQuery = null;
    private String rangeSetQuery = null;
    private String setQuery = null;
    private String setSpecQuery = null;
    private String aboutQuery = null;
    private String aboutValueLabel = null;
    private String setSpecItemLabel = null;
    private String setSpecListLabel = null;
    private String setNameLabel = null;
    private String setDescriptionLabel = null;
    private int maxListSize;
    private String dateFormat = null;
    ArrayList sets = new ArrayList();
    private boolean isPersistentConnection = true;
    private Connection persistentConnection;
    private String jdbcURL = null;
    private String jdbcLogin = null;
    private String jdbcPasswd = null;
    private HashMap resumptionResults = new HashMap();

    public JDBCLimitedOAICatalog(Properties properties) throws IOException {
        String temp;
        this.dateFormat = properties.getProperty("JDBCOAICatalog.dateFormat");
        String maxListSize = properties.getProperty("JDBCLimitedOAICatalog.maxListSize");
        if (maxListSize == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.maxListSize is missing from the properties file");
        }
        this.maxListSize = Integer.parseInt(maxListSize);
        String jdbcDriverName = properties.getProperty("JDBCLimitedOAICatalog.jdbcDriverName");
        if (jdbcDriverName == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.jdbcDriverName is missing from the properties file");
        }
        this.jdbcURL = properties.getProperty("JDBCLimitedOAICatalog.jdbcURL");
        if (this.jdbcURL == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.jdbcURL is missing from the properties file");
        }
        this.jdbcLogin = properties.getProperty("JDBCLimitedOAICatalog.jdbcLogin");
        if (this.jdbcLogin == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.jdbcLogin is missing from the properties file");
        }
        this.jdbcPasswd = properties.getProperty("JDBCLimitedOAICatalog.jdbcPasswd");
        if (this.jdbcPasswd == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.jdbcPasswd is missing from the properties file");
        }
        this.rangeQuery = properties.getProperty("JDBCLimitedOAICatalog.rangeQuery");
        if (this.rangeQuery == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.rangeQuery is missing from the properties file");
        }
        this.rangeSetQuery = properties.getProperty("JDBCLimitedOAICatalog.rangeSetQuery");
        if (this.rangeSetQuery == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.rangeSetQuery is missing from the properties file");
        }
        this.identifierQuery = properties.getProperty("JDBCLimitedOAICatalog.identifierQuery");
        if (this.identifierQuery == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.identifierQuery is missing from the properties file");
        }
        this.aboutQuery = properties.getProperty("JDBCLimitedOAICatalog.aboutQuery");
        if (this.aboutQuery != null) {
            this.aboutValueLabel = properties.getProperty("JDBCLimitedOAICatalog.aboutValueLabel");
            if (this.aboutValueLabel == null) {
                throw new IllegalArgumentException("JDBCLimitedOAICatalog.aboutValueLabel is missing from the properties file");
            }
        }
        this.setSpecQuery = properties.getProperty("JDBCLimitedOAICatalog.setSpecQuery");
        this.setSpecItemLabel = properties.getProperty("JDBCLimitedOAICatalog.setSpecItemLabel");
        if (this.setSpecItemLabel == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.setSpecItemLabel is missing from the properties file");
        }
        this.setSpecListLabel = properties.getProperty("JDBCLimitedOAICatalog.setSpecListLabel");
        if (this.setSpecListLabel == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.setSpecListLabel is missing from the properties file");
        }
        this.setNameLabel = properties.getProperty("JDBCLimitedOAICatalog.setNameLabel");
        if (this.setNameLabel == null) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.setNameLabel is missing from the properties file");
        }
        this.setDescriptionLabel = properties.getProperty("JDBCLimitedOAICatalog.setDescriptionLabel");
        this.setQuery = properties.getProperty("JDBCLimitedOAICatalog.setQuery");
        if (this.setQuery == null) {
            String propertyPrefix = "Sets.";
            Enumeration<?> propNames = properties.propertyNames();
            while (propNames.hasMoreElements()) {
                String propertyName = (String)propNames.nextElement();
                if (!propertyName.startsWith(propertyPrefix)) continue;
                this.sets.add(properties.get(propertyName));
            }
        }
        if ("false".equalsIgnoreCase(temp = properties.getProperty("JDBCLimitedOAICatalog.isPersistentConnection"))) {
            this.isPersistentConnection = false;
        }
        try {
            Class.forName(jdbcDriverName);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("JDBCLimitedOAICatalog.jdbcDriverName is invalid: " + jdbcDriverName);
        }
        if (this.isPersistentConnection) {
            try {
                this.persistentConnection = this.getNewConnection();
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }

    private Connection getNewConnection() throws SQLException {
        return DriverManager.getConnection(this.jdbcURL, this.jdbcLogin, this.jdbcPasswd);
    }

    private Connection startConnection() throws SQLException {
        if (this.persistentConnection != null) {
            if (this.persistentConnection.isClosed()) {
                this.persistentConnection = this.getNewConnection();
            }
            return this.persistentConnection;
        }
        return this.getNewConnection();
    }

    private void endConnection(Connection con) throws OAIInternalServerError {
        try {
            if (this.persistentConnection == null) {
                con.close();
            }
        }
        catch (SQLException e) {
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws OAIInternalServerError, IdDoesNotExistException, NoMetadataFormatsException {
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(this.populateIdentifierQuery(oaiIdentifier));
            if (!rs.next()) {
                this.endConnection(con);
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            HashMap nativeItem = this.getColumnValues(rs);
            this.endConnection(con);
            return this.getRecordFactory().getSchemaLocations(nativeItem);
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    private HashMap getColumnValues(ResultSet rs) throws SQLException {
        ResultSetMetaData mdata = rs.getMetaData();
        int count = mdata.getColumnCount();
        HashMap<String, Object> nativeItem = new HashMap<String, Object>(count);
        int i = 1;
        while (i <= count) {
            String fieldName = mdata.getTableName(i) + "." + mdata.getColumnName(i);
            nativeItem.put(fieldName, rs.getObject(i));
            System.out.println(fieldName + "=" + nativeItem.get(fieldName));
            ++i;
        }
        return nativeItem;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateRangeQuery(String from, String until, String set, int offset, int count) throws OAIInternalServerError {
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = set == null || set.length() == 0 ? new StringTokenizer(this.rangeQuery, "\\") : new StringTokenizer(this.rangeSetQuery, "\\");
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid query");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'a': {
                    sb.append(Integer.toString(offset));
                    break;
                }
                case 'b': {
                    sb.append(Integer.toString(count + 1));
                    break;
                }
                case 'f': {
                    sb.append(this.formatFromDate(from));
                    break;
                }
                case 'u': {
                    sb.append(this.formatUntilDate(until));
                    break;
                }
                case 's': {
                    sb.append(set);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    protected String formatFromDate(String date) {
        return this.formatDate(date);
    }

    protected String formatUntilDate(String date) {
        return this.formatDate(date);
    }

    protected String formatDate(String date) {
        if ("UTC".equals(this.dateFormat)) {
            return date;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(date.substring(5, 7));
        sb.append("/");
        sb.append(date.substring(8));
        sb.append("/");
        sb.append(date.substring(0, 4));
        System.out.println("JDBCLimitedOAICatalog.formatDate: from " + date + " to " + sb.toString());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateIdentifierQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.identifierQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateSetSpecQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.setSpecQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private String populateAboutQuery(String oaiIdentifier) throws OAIInternalServerError {
        StringTokenizer tokenizer = new StringTokenizer(this.aboutQuery, "\\");
        StringBuffer sb = new StringBuffer();
        if (!tokenizer.hasMoreTokens()) {
            throw new OAIInternalServerError("Invalid identifierQuery");
        }
        sb.append(tokenizer.nextToken());
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            switch (token.charAt(0)) {
                case 'i': {
                    sb.append(this.getRecordFactory().fromOAIIdentifier(oaiIdentifier));
                    break;
                }
                case 'o': {
                    sb.append(oaiIdentifier);
                    break;
                }
                default: {
                    sb.append("\\");
                    sb.append(token.charAt(0));
                }
            }
            sb.append(token.substring(1));
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(this.populateRangeQuery(from, until, set, 0, this.maxListSize));
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                HashMap nativeItem = this.getColumnValues(rs);
                RecordFactory rf = this.getRecordFactory();
                Iterator setSpecs = this.getSetSpecs(nativeItem);
                String[] header = this.getRecordFactory().createHeader(nativeItem, setSpecs);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            if (count == 0) {
                this.endConnection(con);
                throw new NoItemsMatchException();
            }
            if (rs.next()) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(from);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(until);
                resumptionTokenSb.append(":");
                if (set == null) {
                    resumptionTokenSb.append(".");
                } else {
                    resumptionTokenSb.append(URLEncoder.encode(set, "UTF-8"));
                }
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(metadataPrefix);
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, 0));
                this.endConnection(con);
            }
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int oldCount;
        String set;
        String until;
        String from;
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            from = tokenizer.nextToken();
            until = tokenizer.nextToken();
            set = tokenizer.nextToken();
            if (set.equals(".")) {
                set = null;
            }
            oldCount = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
            System.out.println("JDBCLimitedOAICatalog.listIdentifiers: set=>" + set + "<");
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(this.populateRangeQuery(from, until, set, oldCount, this.maxListSize));
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                HashMap nativeItem = this.getColumnValues(rs);
                Iterator setSpecs = this.getSetSpecs(nativeItem);
                String[] header = this.getRecordFactory().createHeader(nativeItem, setSpecs);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            if (rs.next()) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(from);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(until);
                resumptionTokenSb.append(":");
                if (set == null) {
                    resumptionTokenSb.append(".");
                } else {
                    resumptionTokenSb.append(URLEncoder.encode(set, "UTF-8"));
                }
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(metadataPrefix);
                listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, oldCount));
                this.endConnection(con);
            }
        }
        catch (UnsupportedEncodingException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws OAIInternalServerError, CannotDisseminateFormatException, IdDoesNotExistException {
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(this.populateIdentifierQuery(oaiIdentifier));
            if (!rs.next()) {
                this.endConnection(con);
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            HashMap nativeItem = this.getColumnValues(rs);
            this.endConnection(con);
            return this.constructRecord(nativeItem, metadataPrefix);
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(this.populateRangeQuery(from, until, set, 0, this.maxListSize));
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                HashMap nativeItem = this.getColumnValues(rs);
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                ++count;
            }
            if (count == 0) {
                this.endConnection(con);
                throw new NoItemsMatchException();
            }
            if (rs.next()) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(from);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(until);
                resumptionTokenSb.append(":");
                if (set == null) {
                    resumptionTokenSb.append(".");
                } else {
                    resumptionTokenSb.append(URLEncoder.encode(set, "UTF-8"));
                }
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(metadataPrefix);
                listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, 0));
                this.endConnection(con);
            }
        }
        catch (UnsupportedEncodingException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int oldCount;
        String set;
        String until;
        String from;
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            from = tokenizer.nextToken();
            until = tokenizer.nextToken();
            set = tokenizer.nextToken();
            if (set.equals(".")) {
                set = null;
            }
            oldCount = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Connection con = null;
        try {
            con = this.startConnection();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(this.populateRangeQuery(from, until, set, oldCount, this.maxListSize));
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                try {
                    HashMap nativeItem = this.getColumnValues(rs);
                    String record = this.constructRecord(nativeItem, metadataPrefix);
                    records.add(record);
                }
                catch (CannotDisseminateFormatException e) {
                    this.endConnection(con);
                    throw new BadResumptionTokenException();
                }
                ++count;
            }
            if (rs.next()) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(from);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(until);
                resumptionTokenSb.append(":");
                if (set == null) {
                    resumptionTokenSb.append(".");
                } else {
                    resumptionTokenSb.append(URLEncoder.encode(set, "UTF-8"));
                }
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(metadataPrefix);
                listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), -1, oldCount));
                this.endConnection(con);
            }
        }
        catch (UnsupportedEncodingException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    private String constructRecord(HashMap nativeItem, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        Iterator abouts = this.getAbouts(nativeItem);
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        return this.getRecordFactory().create(nativeItem, schemaURL, metadataPrefix, setSpecs, abouts);
    }

    public Map listSets() throws NoSetHierarchyException, OAIInternalServerError {
        if (this.setQuery == null) {
            if (this.sets.size() == 0) {
                throw new NoSetHierarchyException();
            }
            HashMap listSetsMap = new HashMap();
            listSetsMap.put("sets", this.sets.iterator());
            return listSetsMap;
        }
        this.purge();
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        Connection con = null;
        try {
            System.out.println(this.setQuery);
            con = this.startConnection();
            Statement stmt = con.createStatement(1004, 1007);
            ResultSet rs = stmt.executeQuery(this.setQuery);
            rs.last();
            int numRows = rs.getRow();
            rs.beforeFirst();
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                HashMap nativeItem = this.getColumnValues(rs);
                sets.add(this.getSetXML(nativeItem));
                System.out.println("JDBCLimitedOAICatalog.listSets: adding an entry");
                ++count;
            }
            if (count < numRows) {
                String resumptionId = JDBCLimitedOAICatalog.getResumptionId();
                this.resumptionResults.put(resumptionId, rs);
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(numRows));
                listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
                this.endConnection(con);
            }
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws OAIInternalServerError, BadResumptionTokenException {
        int numRows;
        int oldCount;
        String resumptionId;
        if (this.setQuery == null) {
            throw new BadResumptionTokenException();
        }
        this.purge();
        HashMap<String, Object> listSetsMap = new HashMap<String, Object>();
        ArrayList<String> sets = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        try {
            ResultSet rs = (ResultSet)this.resumptionResults.get(resumptionId);
            if (rs == null) {
                throw new BadResumptionTokenException();
            }
            if (rs.getRow() != oldCount) {
                rs.absolute(oldCount);
            }
            int count = 0;
            while (count < this.maxListSize && rs.next()) {
                HashMap nativeItem = this.getColumnValues(rs);
                sets.add(this.getSetXML(nativeItem));
                ++count;
            }
            if (oldCount + count < numRows) {
                StringBuffer resumptionTokenSb = new StringBuffer();
                resumptionTokenSb.append(resumptionId);
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(oldCount + count));
                resumptionTokenSb.append(":");
                resumptionTokenSb.append(Integer.toString(numRows));
                listSetsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        listSetsMap.put("sets", sets.iterator());
        return listSetsMap;
    }

    private Iterator getSetSpecs(HashMap nativeItem) throws OAIInternalServerError {
        Connection con = null;
        try {
            ArrayList<String> setSpecs = new ArrayList<String>();
            if (this.setSpecQuery != null) {
                con = this.startConnection();
                RecordFactory rf = this.getRecordFactory();
                String oaiIdentifier = rf.getOAIIdentifier(nativeItem);
                Statement stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(this.populateSetSpecQuery(oaiIdentifier));
                while (rs.next()) {
                    HashMap setMap = this.getColumnValues(rs);
                    setSpecs.add(setMap.get(this.setSpecItemLabel).toString());
                }
                this.endConnection(con);
            }
            return setSpecs.iterator();
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    private Iterator getAbouts(HashMap nativeItem) throws OAIInternalServerError {
        Connection con = null;
        try {
            ArrayList abouts = new ArrayList();
            if (this.aboutQuery != null) {
                con = this.startConnection();
                RecordFactory rf = this.getRecordFactory();
                String oaiIdentifier = rf.getOAIIdentifier(nativeItem);
                Statement stmt = con.createStatement();
                ResultSet rs = stmt.executeQuery(this.populateAboutQuery(oaiIdentifier));
                while (rs.next()) {
                    HashMap aboutMap = this.getColumnValues(rs);
                    abouts.add(aboutMap.get(this.aboutValueLabel));
                }
                this.endConnection(con);
            }
            return abouts.iterator();
        }
        catch (SQLException e) {
            if (con != null) {
                this.endConnection(con);
            }
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public String getSetXML(HashMap setItem) throws IllegalArgumentException {
        String setSpec = this.getSetSpec(setItem);
        String setName = this.getSetName(setItem);
        String setDescription = this.getSetDescription(setItem);
        StringBuffer sb = new StringBuffer();
        sb.append("<set>");
        sb.append("<setSpec>");
        sb.append(OAIUtil.xmlEncode(setSpec));
        sb.append("</setSpec>");
        sb.append("<setName>");
        sb.append(OAIUtil.xmlEncode(setName));
        sb.append("</setName>");
        if (setDescription != null) {
            sb.append("<setDescription>");
            sb.append(OAIUtil.xmlEncode(setDescription));
            sb.append("</setDescription>");
        }
        sb.append("</set>");
        return sb.toString();
    }

    protected String getSetSpec(HashMap setItem) {
        try {
            return URLEncoder.encode((String)setItem.get(this.setSpecListLabel), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "UnsupportedEncodingException";
        }
    }

    protected String getSetName(HashMap setItem) {
        return (String)setItem.get(this.setNameLabel);
    }

    protected String getSetDescription(HashMap setItem) {
        if (this.setDescriptionLabel == null) {
            return null;
        }
        return (String)setItem.get(this.setDescriptionLabel);
    }

    public void close() {
        try {
            if (this.persistentConnection != null) {
                this.persistentConnection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.persistentConnection = null;
    }

    private void purge() {
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            String key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getResumptionId() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }
}

