/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.helpers.RecordStringHandler;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLFileOAICatalog
extends AbstractCatalog {
    private static boolean debug = false;
    private SortedMap nativeMap = null;
    private HashMap resumptionResults = new HashMap();
    private int maxListSize;
    private ArrayList sets = null;
    private Transformer getMetadataTransformer = null;
    private boolean schemaLocationIndexed = false;

    public XMLFileOAICatalog(Properties properties) throws IOException {
        try {
            String getMetadataXSLTName;
            String sourceFile;
            String temp = properties.getProperty("XMLFileOAICatalog.debug");
            if ("true".equals(temp)) {
                debug = true;
            }
            if ("true".equals(temp = properties.getProperty("XMLFileOAICatalog.schemaLocationIndexed"))) {
                this.schemaLocationIndexed = true;
            }
            if ((temp = properties.getProperty("XMLFileOAICatalog.maxListSize")) == null) {
                throw new IllegalArgumentException("XMLFileOAICatalog.maxListSize is missing from the properties file");
            }
            this.maxListSize = Integer.parseInt(temp);
            if (debug) {
                System.out.println("in XMLFileOAICatalog(): maxListSize=" + this.maxListSize);
            }
            if ((sourceFile = properties.getProperty("XMLFileOAICatalog.sourceFile")) == null) {
                throw new IllegalArgumentException("XMLFileOAICatalog.sourceFile is missing from the properties file");
            }
            if (debug) {
                System.out.println("in XMLFileOAICatalog(): sourceFile=" + sourceFile);
            }
            if ((getMetadataXSLTName = properties.getProperty("XMLFileOAICatalog.getMetadataXSLTName")) != null) {
                try {
                    StreamSource xslSource = new StreamSource(new FileInputStream(getMetadataXSLTName));
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    this.getMetadataTransformer = tFactory.newTransformer(xslSource);
                }
                catch (TransformerConfigurationException e) {
                    e.printStackTrace();
                    throw new IOException(e.getMessage());
                }
            }
            RecordStringHandler rsh = new RecordStringHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(sourceFile), (DefaultHandler)rsh);
            this.nativeMap = rsh.getNativeRecords();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
        this.sets = XMLFileOAICatalog.getSets(properties);
    }

    private static ArrayList getSets(Properties properties) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        String propertyPrefix = "Sets.";
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propertyName = (String)propNames.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            treeMap.put(propertyName, properties.get(propertyName));
        }
        return new ArrayList(treeMap.values());
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        Object nativeRecord;
        String localIdentifier;
        String recordid = localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
        if (this.schemaLocationIndexed) {
            recordid = recordid + "/" + metadataPrefix;
        }
        if (debug) {
            System.out.println("XMLFileOAICatalog.getRecord: recordid=" + recordid);
        }
        if ((nativeRecord = this.nativeMap.get(recordid.toLowerCase())) == null) {
            throw new IdDoesNotExistException(oaiIdentifier);
        }
        return this.constructRecord(nativeRecord, metadataPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetadata(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        HashMap nativeRecord;
        String localIdentifier;
        String recordid = localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
        if (this.schemaLocationIndexed) {
            recordid = recordid + "/" + metadataPrefix;
        }
        if (debug) {
            System.out.println("XMLFileOAICatalog.getRecord: recordid=" + recordid);
        }
        if ((nativeRecord = (HashMap)this.nativeMap.get(recordid.toLowerCase())) == null) {
            throw new IdDoesNotExistException(oaiIdentifier);
        }
        if (debug) {
            Iterator keys = nativeRecord.keySet().iterator();
            while (keys.hasNext()) {
                System.out.println(keys.next());
            }
        }
        String result = (String)nativeRecord.get("recordString");
        if (this.getMetadataTransformer != null) {
            StringReader stringReader = new StringReader(result);
            StreamSource streamSource = new StreamSource(stringReader);
            StringWriter stringWriter = new StringWriter();
            try {
                Transformer transformer = this.getMetadataTransformer;
                synchronized (transformer) {
                    this.getMetadataTransformer.transform(streamSource, new StreamResult(stringWriter));
                }
            }
            catch (TransformerException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            result = stringWriter.toString();
        }
        return result;
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws IdDoesNotExistException, OAIInternalServerError, NoMetadataFormatsException {
        Vector v = new Vector();
        String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
        Iterator iterator = this.nativeMap.entrySet().iterator();
        int numRows = this.nativeMap.entrySet().size();
        int i = 0;
        while (i < numRows) {
            Map.Entry entryNativeMap = iterator.next();
            HashMap nativeRecord = (HashMap)entryNativeMap.getValue();
            if (this.getRecordFactory().getOAIIdentifier(nativeRecord).equals(oaiIdentifier)) {
                Vector schemaLocations = this.getRecordFactory().getSchemaLocations(nativeRecord);
                Iterator itemIterator = schemaLocations.iterator();
                while (itemIterator.hasNext()) {
                    v.add(itemIterator.next());
                }
            }
            ++i;
        }
        if (v.size() > 0) {
            return v;
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Iterator iterator = this.nativeMap.entrySet().iterator();
        int numRows = this.nativeMap.entrySet().size();
        int count = 0;
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryNativeMap = iterator.next();
            HashMap nativeRecord = (HashMap)entryNativeMap.getValue();
            String recordDate = this.getRecordFactory().getDatestamp(nativeRecord);
            String schemaLocation = (String)nativeRecord.get("schemaLocation");
            List setSpecs = (List)nativeRecord.get("setSpecs");
            if (recordDate.compareTo(from) < 0 || recordDate.compareTo(until) > 0 || this.schemaLocationIndexed && !schemaLocation.equals(this.getCrosswalks().getSchemaLocation(metadataPrefix)) || set != null && !setSpecs.contains(set)) continue;
            String[] header = this.getRecordFactory().createHeader(nativeRecord);
            headers.add(header[0]);
            identifiers.add(header[1]);
            ++count;
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = XMLFileOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("XMLFileOAICatalog.listIdentifiers: reuse of old resumptionToken?");
            iterator = this.nativeMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        int count = 0;
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryNativeMap = iterator.next();
            Object nativeRecord = this.nativeMap.get((String)entryNativeMap.getKey());
            String[] header = this.getRecordFactory().createHeader(nativeRecord);
            headers.add(header[0]);
            identifiers.add(header[1]);
            ++count;
        }
        if (iterator.hasNext()) {
            resumptionId = XMLFileOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    private String constructRecord(Object nativeRecord, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeRecord);
        Iterator abouts = this.getAbouts(nativeRecord);
        if (metadataPrefix != null) {
            if (debug) {
                System.out.println(this.getCrosswalks());
            }
            if ((schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
        }
        return this.getRecordFactory().create(nativeRecord, schemaURL, metadataPrefix, setSpecs, abouts);
    }

    private Iterator getSetSpecs(Object nativeRecord) throws OAIInternalServerError {
        try {
            return this.getRecordFactory().getSetSpecs(nativeRecord);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    private Iterator getAbouts(Object nativeRecord) throws OAIInternalServerError {
        return null;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        String requestedSchemaLocation = this.getCrosswalks().getSchemaLocation(metadataPrefix);
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        LinkedList<String> records = new LinkedList<String>();
        Iterator iterator = this.nativeMap.entrySet().iterator();
        int numRows = this.nativeMap.entrySet().size();
        if (debug) {
            System.out.println("XMLFileOAICatalog.listRecords: numRows=" + numRows);
        }
        int count = 0;
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryNativeMap = iterator.next();
            HashMap nativeRecord = (HashMap)entryNativeMap.getValue();
            String recordDate = this.getRecordFactory().getDatestamp(nativeRecord);
            String schemaLocation = (String)nativeRecord.get("schemaLocation");
            List setSpecs = (List)nativeRecord.get("setSpecs");
            if (debug) {
                System.out.println("XMLFileOAICatalog.listRecord: recordDate=" + recordDate);
                System.out.println("XMLFileOAICatalog.listRecord: requestedSchemaLocation=" + requestedSchemaLocation);
                System.out.println("XMLFileOAICatalog.listRecord: schemaLocation=" + schemaLocation);
            }
            if (recordDate.compareTo(from) < 0 || recordDate.compareTo(until) > 0 || this.schemaLocationIndexed && !requestedSchemaLocation.equals(schemaLocation) || set != null && !setSpecs.contains(set)) continue;
            String record = this.constructRecord(nativeRecord, metadataPrefix);
            if (debug) {
                System.out.println("XMLFileOAICatalog.listRecords: record=" + record);
            }
            records.add(record);
            ++count;
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = XMLFileOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        int count;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        LinkedList<String> records = new LinkedList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("XMLFileOAICatalog.listRecords: reuse of old resumptionToken?");
            iterator = this.nativeMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        for (count = 0; count < this.maxListSize && iterator.hasNext(); ++count) {
            Map.Entry entryNativeMap = iterator.next();
            try {
                Object nativeRecord = this.nativeMap.get((String)entryNativeMap.getKey());
                String record = this.constructRecord(nativeRecord, metadataPrefix);
                records.add(record);
                continue;
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
        }
        if (iterator.hasNext()) {
            resumptionId = XMLFileOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listSets() throws OAIInternalServerError, NoSetHierarchyException {
        if (this.sets.size() == 0) {
            throw new NoSetHierarchyException();
        }
        LinkedHashMap listSetsMap = new LinkedHashMap();
        listSetsMap.put("sets", this.sets.iterator());
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        throw new BadResumptionTokenException();
    }

    public void close() {
    }

    private void purge() {
        String key;
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getRSName() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }
}

