<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="4.0" />
	<xsl:param name="intdocs"
		select="'xml html htm txt jpg png gif XML HTML HTM TXT JPG PNG GIF'" />
	<xsl:param name="rendererURI" select="''" />
	<xsl:param name="upnode" />

	<xsl:template name="makeUri">
		<xsl:param name="uri" />
		<xsl:variable name="injac-file">
			<xsl:call-template name="last-rep">
				<xsl:with-param name="last-rep-uri" select="$uri" />
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="injac-path"
			select="substring-before(substring-after($uri, $upnode), concat('/',$injac-file))" />
		<xsl:choose>
			<xsl:when test="rendererURI = ''">
				<a class="file"
					href="{$uri}">
					<xsl:value-of select="$uri" />
				</a>
			</xsl:when>
			<xsl:otherwise>
				<!-- Test des types de document au rendu externe -->
				<xsl:choose>
					<!-- extern rendering link-->
					<xsl:when
						test="not(contains($intdocs, substring-after($injac-file, '.')))">
						<a class="file"
							href="http://saroumane.enseeiht.fr:810/cocoon/injac/ext/{$injac-file}?path={$injac-path}/{$injac-file}&amp;file={$injac-file}">
							<xsl:value-of select="$uri" />
						</a>
					</xsl:when>
					<xsl:otherwise>
						<a class="file"
							href="http://saroumane.enseeiht.fr:810/cocoon/injac/?path={$injac-path}&amp;doc=/{$injac-file}">
							<xsl:value-of select="$uri" />
						</a>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- sous-template recursif simulant la fonction lastOf() -->
	<xsl:template name="last-rep">
		<xsl:param name="last-rep-uri" />
		<xsl:choose>
			<xsl:when test="contains($last-rep-uri, '/')">
				<xsl:call-template name="last-rep">
					<xsl:with-param name="last-rep-uri"
						select="substring-after($last-rep-uri, '/')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$last-rep-uri" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
