<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:lom="http://injac.esup.org/lomfr">
	<xsl:output method="html" version="4.0" />
	<xsl:include href="common_templates.xsl"/>
	<!-- IHM LOM transformations -->
	<xsl:template match="lom:lom">
		<table width="100%" border="0" cellspacing="4"
			cellpadding="0">
			<xsl:apply-templates />
		</table>
	</xsl:template>


	<xsl:template
		match="lom:general|lom:lifeCycle|lom:technical|lom:educational">
		<tr valign="top">
			<td width="150">
				<h3>
					<strong>
						<xsl:value-of select="name()" />
					</strong>
				</h3>
			</td>
			<td>
				<table>
					<xsl:for-each
						select="*[name() != 'lom:location']">
						<tr valign="top">
							<td width="150">
								<strong>
									<xsl:value-of select="name()" />
								</strong>
							</td>
							<td>
								<xsl:value-of select="." />
							</td>
						</tr>
					</xsl:for-each>
					<xsl:apply-templates select="lom:location" />
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="lom:location">
		<tr valign="top">
			<td>
				<strong>
					<xsl:value-of select="name()" />
				</strong>
			</td>
			<td>
				<xsl:call-template name="makeUri">
					<xsl:with-param name="uri" select="." />
				</xsl:call-template>
			</td>
		</tr>
	</xsl:template>
	<!-- LOM -->
</xsl:stylesheet>