/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.crosswalk;

import ORG.oclc.RecordHandler.MalformedRecordException;
import ORG.oclc.ber.DataDir;
import ORG.oclc.oai.server.catalog.XMLDataDirRecordFactory;
import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class DataDir2xsd
extends Crosswalk {
    public DataDir2xsd(Properties properties) {
        super("http://www.w3.org/2001/XMLSchema http://www.w3.org/2001/XMLSchema.xsd");
    }

    public boolean isAvailableFor(Object nativeItem) {
        return this.getDataDir((DataDir)nativeItem) != null;
    }

    private DataDir getDataDir(DataDir nativeItem) {
        DataDir dir = nativeItem.find(13);
        if (dir != null) {
            dir = dir.child();
        }
        while (dir != null) {
            String schemaLocation = dir.find(2).find(17).getString();
            if (schemaLocation.equals(this.getSchemaLocation())) {
                return dir;
            }
            dir = dir.next();
        }
        return null;
    }

    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        try {
            DataDir dir = this.getDataDir((DataDir)nativeItem);
            if (dir != null) {
                return new String(XMLDataDirRecordFactory.fromDataDir(dir), "UTF8");
            }
            throw new CannotDisseminateFormatException(this.getSchemaLocation());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("IOException error occurred");
        }
        catch (MalformedRecordException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("IOException error occurred");
        }
    }
}

