/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.io;

import ORG.oclc.oai.harvester.verb.Header;
import ORG.oclc.oai.harvester.verb.ListIdentifiers;
import ORG.oclc.oai.harvester.verb.OAIError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.xml.sax.SAXException;

public class ListIdentifiersReader {
    private URL baseURL;
    private String resumptionToken = null;
    private Iterator headers = null;

    public ListIdentifiersReader(URL baseURL, String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this(baseURL, null, null, null, metadataPrefix);
    }

    public ListIdentifiersReader(URL baseURL, String from, String until, String set, String metadataPrefix) throws MalformedURLException, SAXException, IOException, OAIError {
        this.baseURL = baseURL;
        ListIdentifiers listIdentifiers = new ListIdentifiers(baseURL, from, until, set, metadataPrefix);
        if (listIdentifiers != null) {
            ArrayList errors = listIdentifiers.getErrors();
            if (errors != null) {
                throw (OAIError)errors.get(0);
            }
            this.headers = listIdentifiers.iterator();
            this.resumptionToken = listIdentifiers.getResumptionToken();
        }
    }

    public Header readNext() throws MalformedURLException, SAXException, IOException, OAIError {
        while (this.headers != null && !this.headers.hasNext()) {
            if (this.resumptionToken == null) {
                return null;
            }
            ListIdentifiers listIdentifiers = new ListIdentifiers(this.baseURL, this.resumptionToken);
            if (listIdentifiers != null) {
                ArrayList errors = listIdentifiers.getErrors();
                if (errors != null) {
                    throw (OAIError)errors.get(0);
                }
                this.headers = listIdentifiers.iterator();
                this.resumptionToken = listIdentifiers.getResumptionToken();
                continue;
            }
            return null;
        }
        if (this.headers == null) {
            return null;
        }
        return (Header)this.headers.next();
    }

    public void close() {
    }
}

