/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.harvester.verb;

import ORG.oclc.oai.harvester.verb.OAIError;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipInputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class HarvesterVerb
extends DefaultHandler {
    public static final String OAI20_NS = "http://www.openarchives.org/OAI/2.0/";
    public static final String OAI20_OAIPMH = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "OAI-PMH");
    public static final String OAI20_METADATA = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "metadata");
    public static final String OAI20_ABOUT = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "about");
    public static final String OAI20_IDENTIFIER = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "identifier");
    public static final String OAI20_DATESTAMP = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "datestamp");
    public static final String OAI20_SETSPEC = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "setSpec");
    public static final String OAI20_RECORD = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "record");
    public static final String OAI20_SET = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "set");
    public static final String OAI20_METADATAFORMAT = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "metadataFormat");
    public static final String OAI20_HEADER = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "header");
    public static final String OAI20_ERROR = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "error");
    public static final String OAI20_RESPONSE_DATE = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "responseDate");
    public static final String OAI20_REQUEST_URL = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "request");
    public static final String OAI20_RESUMPTION_TOKEN = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "resumptionToken");
    public static final String OAI20_STATUS = HarvesterVerb.fullName("http://www.openarchives.org/OAI/2.0/", "status");
    private static final boolean debug = false;
    private static int INITIAL_BAOS_SIZE = 786432;
    private static HashMap xmlReaders = new HashMap();
    private byte[] responseBuffer = null;
    private String fullName = null;
    private String responseDate;
    private String request;
    private boolean errorCapture = false;
    private String errorCode = null;
    private StringBuffer errorMessage;
    private ArrayList errors = new ArrayList();
    private byte[] response = null;

    protected XMLReader getXMLReader() throws SAXException {
        Thread currentThread = Thread.currentThread();
        XMLReader xmlReader = (XMLReader)xmlReaders.get(currentThread);
        if (xmlReader == null) {
            try {
                xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            }
            catch (SAXException e) {
                try {
                    xmlReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                }
                catch (SAXException e1) {
                    try {
                        xmlReader = XMLReaderFactory.createXMLReader("com.bluecase.xml.Piccolo");
                    }
                    catch (SAXException e2) {
                        try {
                            xmlReader = XMLReaderFactory.createXMLReader("oracle.xml.parser.v2.SAXParser");
                        }
                        catch (SAXException e3) {
                            try {
                                xmlReader = XMLReaderFactory.createXMLReader();
                            }
                            catch (SAXException e4) {
                                throw new SAXException("No SAX parser available");
                            }
                        }
                    }
                }
            }
            xmlReaders.put(currentThread, xmlReader);
        }
        return xmlReader;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("HarvesterVerb.responseDate: ");
        sb.append(this.responseDate);
        sb.append("\nHarvesterVerb.request: ");
        sb.append(this.request);
        sb.append("\n");
        Iterator iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            sb.append("HarvesterVerb.errors: ");
            sb.append(iterator.next());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getResponseDate() {
        return this.responseDate;
    }

    public String getRequestURL() {
        return this.request;
    }

    public String getRequest() {
        return this.request;
    }

    public byte[] getResponseBuffer() {
        return this.responseBuffer;
    }

    public ArrayList getErrors() {
        if (this.errors.size() != 0) {
            return this.errors;
        }
        return null;
    }

    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        this.fullName = HarvesterVerb.fullName(namespaceURI, sName);
        if (this.fullName.equals(OAI20_ERROR)) {
            this.errorCode = attrs.getValue("code");
            this.errorCapture = true;
            this.errorMessage = new StringBuffer();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        String fullName = HarvesterVerb.fullName(namespaceURI, localName);
        if (fullName.equals(OAI20_ERROR)) {
            this.errorCapture = false;
            this.errors.add(new OAIError(this.errorCode, this.errorMessage.toString()));
        }
        this.fullName = null;
    }

    public void characters(char[] buf, int offset, int len) {
        if (OAI20_RESPONSE_DATE.equals(this.fullName)) {
            this.responseDate = new String(buf, offset, len);
        } else if (OAI20_REQUEST_URL.equals(this.fullName)) {
            this.request = new String(buf, offset, len);
        } else if (OAI20_ERROR.equals(this.fullName)) {
            this.errorMessage.append(new String(buf, offset, len));
        }
    }

    protected InputStream getResponseStream(String uri) throws IOException {
        InputStream in = null;
        URL url = new URL(uri);
        HttpURLConnection con = null;
        int responseCode = 0;
        do {
            con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("User-Agent", "OAIHarvester/2.0");
            con.setRequestProperty("Accept-Encoding", "compress, gzip, deflate, identify");
            try {
                responseCode = con.getResponseCode();
            }
            catch (FileNotFoundException e) {
                responseCode = 503;
            }
            if (responseCode != 503) continue;
            long retrySeconds = con.getHeaderFieldInt("Retry-After", -1);
            if (retrySeconds == -1L) {
                long now = new Date().getTime();
                long retryDate = con.getHeaderFieldDate("Retry-After", now);
                retrySeconds = retryDate - now;
            }
            if (retrySeconds == 0L) {
                throw new FileNotFoundException("Bad URL?");
            }
            System.err.println("Server response: Retry-After=" + retrySeconds);
            if (retrySeconds <= 0L) continue;
            try {
                Thread.sleep(retrySeconds * 1000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        } while (responseCode == 503);
        String contentEncoding = con.getHeaderField("Content-Encoding");
        if ("compress".equals(contentEncoding)) {
            ZipInputStream zis = new ZipInputStream(con.getInputStream());
            zis.getNextEntry();
            in = zis;
        } else {
            in = "gzip".equals(contentEncoding) ? new GZIPInputStream(con.getInputStream()) : ("deflate".equals(contentEncoding) ? new InflaterInputStream(con.getInputStream()) : con.getInputStream());
        }
        return this.captureResponse(in);
    }

    private InputStream captureResponse(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(INITIAL_BAOS_SIZE);
        byte[] buffer = new byte[INITIAL_BAOS_SIZE];
        int count = 0;
        BufferedInputStream bis = new BufferedInputStream(in);
        while ((count = bis.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        this.responseBuffer = baos.toByteArray();
        return new ByteArrayInputStream(this.responseBuffer);
    }

    public static String fullName(String namespaceURI, String localName) {
        StringBuffer sb = new StringBuffer();
        sb.append(namespaceURI);
        sb.append("#");
        sb.append(localName);
        return sb.toString();
    }
}

