/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class SupportedFormats {
    private Map supportedFormatsMap = new HashMap();

    public SupportedFormats(Properties properties) {
        String propertyPrefix = "SupportedFormats.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            String schemaLabel = propertyName.substring(propertyPrefix.length());
            String schemaLocation = (String)properties.get(propertyName);
            this.supportedFormatsMap.put(schemaLocation, schemaLabel);
        }
        if (this.supportedFormatsMap.size() == 0) {
            System.err.println("SupportedFormats entries are missing from properties file");
        }
    }

    public String getMetadataPrefix(String namespaceURI, String schemaURL) {
        return (String)this.supportedFormatsMap.get(namespaceURI + " " + schemaURL);
    }

    public String getSchemaURL(String metadataPrefix) {
        String schemaLocation = this.getSchemaLocation(metadataPrefix);
        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }

    public String getNamespaceURI(String metadataPrefix) {
        String schemaLocation = this.getSchemaLocation(metadataPrefix);
        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        return tokenizer.nextToken();
    }

    public String getSchemaLocation(String metadataPrefix) {
        Iterator iterator = this.supportedFormatsMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String value = (String)entry.getValue();
            if (!value.equals(metadataPrefix)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public boolean containsValue(String metadataPrefix) {
        return this.supportedFormatsMap.containsValue(metadataPrefix);
    }

    public Iterator iterator() {
        return this.supportedFormatsMap.entrySet().iterator();
    }
}

