/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class NewFileSystemOAICatalog
extends AbstractCatalog {
    static final boolean debug = false;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat();
    protected String homeDir;
    private HashMap fileDateMap = new HashMap();
    private HashMap setMap = new HashMap();
    private HashMap resumptionResults = new HashMap();
    private int maxListSize;
    private ArrayList sets = null;

    public NewFileSystemOAICatalog(Properties properties) throws IOException {
        this.dateFormatter.applyPattern("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String temp = properties.getProperty("NewFileSystemOAICatalog.maxListSize");
        if (temp == null) {
            throw new IllegalArgumentException("NewFileSystemOAICatalog.maxListSize is missing from the properties file");
        }
        this.maxListSize = Integer.parseInt(temp);
        this.homeDir = properties.getProperty("NewFileSystemOAICatalog.homeDir");
        if (this.homeDir == null) {
            throw new IllegalArgumentException("NewFileSystemOAICatalog.homeDir is missing from the properties file");
        }
        File homeFile = new File(this.homeDir);
        int homeDirLen = homeFile.getPath().length() + 1;
        this.loadFileMap(homeDirLen, homeFile);
        this.sets = NewFileSystemOAICatalog.getSets(properties);
    }

    private static ArrayList getSets(Properties properties) {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        String propertyPrefix = "Sets.";
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propertyName = (String)propNames.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            treeMap.put(propertyName, properties.get(propertyName));
        }
        return new ArrayList(treeMap.values());
    }

    private void loadFileMap(int homeDirLen, File currentDir) throws IOException {
        try {
            String[] list = currentDir.list();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            int i = 0;
            while (i < list.length) {
                File child = new File(currentDir, list[i]);
                if (child.isDirectory() && !"CVS".equals(child.getName())) {
                    this.loadFileMap(homeDirLen, child);
                } else if (this.isMetadataFile(child)) {
                    String path = this.file2path(homeDirLen, child);
                    System.out.println("parsing " + path);
                    File file = this.localIdentifier2File(path);
                    FileInputStream fis = new FileInputStream(file);
                    InputSource data = new InputSource(fis);
                    Document doc = builder.parse(data);
                    fis.close();
                    Node datestampNode = XPathAPI.selectSingleNode((Node)doc, (String)"/record/header/datestamp");
                    this.fileDateMap.put(path, XPathAPI.eval((Node)datestampNode, (String)"string()").str());
                    NodeList setNodes = XPathAPI.selectNodeList((Node)doc, (String)"/record/header/setSpec");
                    int j = 0;
                    while (j < setNodes.getLength()) {
                        Node setSpecNode = setNodes.item(j);
                        String setSpec = XPathAPI.eval((Node)setSpecNode, (String)"string()").str();
                        ArrayList<String> setSpecList = (ArrayList<String>)this.setMap.get(setSpec);
                        if (setSpecList == null) {
                            setSpecList = new ArrayList<String>();
                            this.setMap.put(setSpec, setSpecList);
                        }
                        setSpecList.add(path);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    protected boolean isMetadataFile(File child) {
        return true;
    }

    protected String file2path(int homeDirLen, File file) {
        String fileName = file.getPath().substring(homeDirLen).replace(File.separatorChar, '/');
        return fileName;
    }

    protected File localIdentifier2File(String localIdentifier) {
        String fileName = localIdentifier.replace('/', File.separatorChar);
        return new File(this.homeDir, fileName);
    }

    private HashMap getNativeHeader(String path) throws IOException {
        HashMap<String, Object> recordMap = null;
        if (this.fileDateMap.containsKey(path)) {
            recordMap = new HashMap<String, Object>();
            recordMap.put("localIdentifier", path.substring(0, path.lastIndexOf(".")));
            recordMap.put("lastModified", this.fileDateMap.get(path));
            ArrayList<String> setSpecs = new ArrayList<String>();
            Iterator keySet = this.setMap.keySet().iterator();
            while (keySet.hasNext()) {
                String key = (String)keySet.next();
                ArrayList identifierList = (ArrayList)this.setMap.get(key);
                if (!identifierList.contains(path)) continue;
                setSpecs.add(key);
            }
            recordMap.put("setSpecs", setSpecs.iterator());
            return recordMap;
        }
        return recordMap;
    }

    private ArrayList getExtensionList(String localIdentifier) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = this.fileDateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((String)entry.getKey()).startsWith(localIdentifier)) continue;
            list.add(((String)entry.getKey()).substring(localIdentifier.length() + 1));
        }
        return list;
    }

    private HashMap getNativeRecord(String path) throws IOException {
        HashMap recordMap = this.getNativeHeader(path);
        if (recordMap == null) {
            return null;
        }
        File file = this.localIdentifier2File(path);
        try {
            FileInputStream fis = new FileInputStream(file);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] buffer = new byte[(int)file.length()];
            bis.read(buffer, 0, (int)file.length());
            recordMap.put("recordBytes", buffer);
            bis.close();
            fis.close();
            return recordMap;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        HashMap nativeItem = null;
        try {
            String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
            nativeItem = this.getNativeRecord(localIdentifier + "." + metadataPrefix);
            if (nativeItem == null) {
                throw new IdDoesNotExistException(oaiIdentifier);
            }
            return this.constructRecord(nativeItem, metadataPrefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws IdDoesNotExistException, OAIInternalServerError, NoMetadataFormatsException {
        ArrayList extensionList = null;
        String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
        extensionList = this.getExtensionList(localIdentifier);
        if (extensionList != null) {
            return this.getRecordFactory().getSchemaLocations(extensionList);
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Iterator iterator = this.fileDateMap.entrySet().iterator();
        int numRows = this.fileDateMap.entrySet().size();
        int count = 0;
        ArrayList setIdentifiers = (ArrayList)this.setMap.get(set);
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String fileDate = (String)entryDateMap.getValue();
            String path = (String)entryDateMap.getKey();
            if (fileDate.compareTo(from) < 0 || fileDate.compareTo(until) > 0 || setIdentifiers != null && !setIdentifiers.contains(path)) continue;
            try {
                HashMap nativeHeader = this.getNativeHeader((String)entryDateMap.getKey());
                String[] header = this.getRecordFactory().createHeader(nativeHeader);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = NewFileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(set);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String set;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
            set = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("NewFileSystemOAICatalog.listIdentifiers: reuse of old resumptionToken?");
            iterator = this.fileDateMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        int count = 0;
        ArrayList setIdentifiers = (ArrayList)this.setMap.get(set);
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String path = (String)entryDateMap.getKey();
            if (setIdentifiers != null && !setIdentifiers.contains(path)) continue;
            try {
                HashMap nativeHeader = this.getNativeHeader((String)entryDateMap.getKey());
                String[] header = this.getRecordFactory().createHeader(nativeHeader);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++count;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (iterator.hasNext()) {
            resumptionId = NewFileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(set);
            listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listIdentifiersMap.put("headers", headers.iterator());
        listIdentifiersMap.put("identifiers", identifiers.iterator());
        return listIdentifiersMap;
    }

    private String constructRecord(HashMap nativeItem, String metadataPrefix) throws CannotDisseminateFormatException, OAIInternalServerError {
        String schemaURL = null;
        Iterator setSpecs = this.getSetSpecs(nativeItem);
        Iterator abouts = this.getAbouts(nativeItem);
        if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
            throw new CannotDisseminateFormatException(metadataPrefix);
        }
        return this.getRecordFactory().create(nativeItem, schemaURL, metadataPrefix, setSpecs, abouts);
    }

    private Iterator getSetSpecs(HashMap nativeItem) throws OAIInternalServerError {
        return null;
    }

    private Iterator getAbouts(HashMap nativeItem) throws OAIInternalServerError {
        return null;
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, OAIInternalServerError, NoItemsMatchException {
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        Iterator iterator = this.fileDateMap.entrySet().iterator();
        int numRows = this.fileDateMap.entrySet().size();
        int count = 0;
        ArrayList setIdentifiers = (ArrayList)this.setMap.get(set);
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String fileDate = (String)entryDateMap.getValue();
            String path = (String)entryDateMap.getKey();
            String extension = path.substring(path.lastIndexOf(".") + 1);
            if (fileDate.compareTo(from) < 0 || fileDate.compareTo(until) > 0 || !extension.equals(metadataPrefix) || setIdentifiers != null && !setIdentifiers.contains(path)) continue;
            try {
                HashMap nativeItem = this.getNativeRecord((String)entryDateMap.getKey());
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                ++count;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
        }
        if (count == 0) {
            throw new NoItemsMatchException();
        }
        if (iterator.hasNext()) {
            String resumptionId = NewFileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(set);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, 0));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        String set;
        String metadataPrefix;
        int numRows;
        int oldCount;
        String resumptionId;
        this.purge();
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> records = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            resumptionId = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            numRows = Integer.parseInt(tokenizer.nextToken());
            metadataPrefix = tokenizer.nextToken();
            set = tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        Iterator iterator = (Iterator)this.resumptionResults.remove(resumptionId);
        if (iterator == null) {
            System.out.println("NewFileSystemOAICatalog.listRecords: reuse of old resumptionToken?");
            iterator = this.fileDateMap.entrySet().iterator();
            int i = 0;
            while (i < oldCount) {
                iterator.next();
                ++i;
            }
        }
        int count = 0;
        ArrayList setIdentifiers = (ArrayList)this.setMap.get(set);
        while (count < this.maxListSize && iterator.hasNext()) {
            Map.Entry entryDateMap = iterator.next();
            String path = (String)entryDateMap.getKey();
            if (setIdentifiers != null && !setIdentifiers.contains(path)) continue;
            try {
                HashMap nativeItem = this.getNativeRecord((String)entryDateMap.getKey());
                String record = this.constructRecord(nativeItem, metadataPrefix);
                records.add(record);
                ++count;
            }
            catch (CannotDisseminateFormatException e) {
                throw new BadResumptionTokenException();
            }
            catch (IOException e) {
                throw new BadResumptionTokenException();
            }
        }
        if (iterator.hasNext()) {
            resumptionId = NewFileSystemOAICatalog.getRSName();
            this.resumptionResults.put(resumptionId, iterator);
            StringBuffer resumptionTokenSb = new StringBuffer();
            resumptionTokenSb.append(resumptionId);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(oldCount + count));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(Integer.toString(numRows));
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(metadataPrefix);
            resumptionTokenSb.append(":");
            resumptionTokenSb.append(set);
            listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionTokenSb.toString(), numRows, oldCount));
        }
        listRecordsMap.put("records", records.iterator());
        return listRecordsMap;
    }

    public Map listSets() throws OAIInternalServerError, NoSetHierarchyException {
        if (this.sets.size() == 0) {
            throw new NoSetHierarchyException();
        }
        LinkedHashMap listSetsMap = new LinkedHashMap();
        listSetsMap.put("sets", this.sets.iterator());
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        throw new BadResumptionTokenException();
    }

    public void close() {
    }

    private void purge() {
        String key;
        ArrayList<String> old = new ArrayList<String>();
        Date now = new Date();
        Iterator keySet = this.resumptionResults.keySet().iterator();
        while (keySet.hasNext()) {
            key = (String)keySet.next();
            Date then = new Date(Long.parseLong(key) + (long)this.getMillisecondsToLive());
            if (!now.after(then)) continue;
            old.add(key);
        }
        Iterator iterator = old.iterator();
        while (iterator.hasNext()) {
            key = (String)iterator.next();
            this.resumptionResults.remove(key);
        }
    }

    private static synchronized String getRSName() {
        Date now = new Date();
        return Long.toString(now.getTime());
    }
}

