/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.catalog.RecordFactory;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadResumptionTokenException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.NoItemsMatchException;
import ORG.oclc.oai.server.verb.NoMetadataFormatsException;
import ORG.oclc.oai.server.verb.NoSetHierarchyException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SRUOAICatalog
extends AbstractCatalog {
    private static final boolean debug = true;
    private String sruURL;
    private String sortKeys = "";
    protected int maxListSize;
    private static String maxDate = ServerVerb.createResponseDate(new Date());
    private TreeMap sets = null;
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static Transformer transformer = null;
    private static DocumentBuilder builder = null;
    private static Element xmlnsEl = null;
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public SRUOAICatalog(Properties properties) throws IOException {
        this(properties, properties.getProperty("SRUOAICatalog.sruURL"));
    }

    public SRUOAICatalog(Properties properties, String sruURL) throws IOException {
        String maxListSize;
        this.sortKeys = properties.getProperty("SRUOAICatalog.sortKeys");
        if (this.sortKeys == null) {
            this.sortKeys = "";
        }
        if ((maxListSize = properties.getProperty("SRUOAICatalog.maxListSize")) == null) {
            throw new IllegalArgumentException("SRUOAICatalog.maxListSize is missing from the properties file");
        }
        this.maxListSize = Integer.parseInt(maxListSize);
        this.sruURL = sruURL;
        this.sets = SRUOAICatalog.getSets(properties);
    }

    private static TreeMap getSets(Properties properties) {
        TreeMap treeMap = new TreeMap();
        return treeMap;
    }

    private String normalizeTerm(String term) {
        return term;
    }

    public Map listSets() throws NoSetHierarchyException {
        if (this.sets.size() == 0) {
            throw new NoSetHierarchyException();
        }
        LinkedHashMap listSetsMap = new LinkedHashMap();
        try {
            Object[] keys = this.sets.keySet().toArray();
            Object[] values = this.sets.values().toArray();
            ArrayList<String> newList = new ArrayList<String>();
            int i = 0;
            while (i < keys.length) {
                newList.add((String)values[i]);
                ++i;
            }
            listSetsMap.put("sets", newList.iterator());
        }
        catch (Throwable e) {
            System.err.println("SRUOAICatalog.listSets: browse failed");
            e.printStackTrace();
        }
        return listSetsMap;
    }

    public Map listSets(String resumptionToken) throws BadResumptionTokenException {
        throw new BadResumptionTokenException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map listIdentifiers(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        Document srResponse;
        if (set != null && set.length() > 0 && from.equals(this.toFinestFrom("0000-00-00")) && until.equals(this.toFinestUntil("9999-99-99"))) {
            from = null;
            until = null;
        }
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        try {
            srResponse = this.getSearchRetrieveResponse(this.sruURL, from, until, set, "http://www.openarchives.org/OAI/2.0/#header", 1, this.maxListSize, "xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        try {
            NodeList nodeList = this.getRecords(srResponse);
            if (nodeList == null) throw new NoItemsMatchException();
            RecordFactory recordFactory = this.getRecordFactory();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element rec = this.getRecordData(nodeList.item(i));
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("header", rec);
                String localIdentifier = this.getRecordFactory().getLocalIdentifier(hashMap);
                try {
                    hashMap.put("metadata", this.getNativeMetadata(localIdentifier, metadataPrefix));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new OAIInternalServerError(e.getMessage());
                }
                catch (TransformerException e) {
                    e.printStackTrace();
                    throw new OAIInternalServerError(e.getMessage());
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                    throw new OAIInternalServerError(e.getMessage());
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    throw new OAIInternalServerError(e.getMessage());
                }
                String[] header = recordFactory.createHeader(hashMap);
                headers.add(header[0]);
                identifiers.add(header[1]);
                ++i;
            }
            try {
                if (this.getNumberOfRecords(srResponse) > nodeList.getLength()) {
                    StringBuffer resumptionToken = new StringBuffer();
                    resumptionToken.append(from);
                    resumptionToken.append(":");
                    resumptionToken.append(until);
                    resumptionToken.append(":");
                    resumptionToken.append(set);
                    resumptionToken.append(":");
                    resumptionToken.append(metadataPrefix);
                    resumptionToken.append(":");
                    resumptionToken.append(nodeList.getLength());
                    listIdentifiersMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString()));
                }
            }
            catch (TransformerException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            listIdentifiersMap.put("headers", headers.iterator());
            listIdentifiersMap.put("identifiers", identifiers.iterator());
            return listIdentifiersMap;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public Map listIdentifiers(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        int oldCount;
        String metadataPrefix;
        String set;
        String until;
        String from;
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            from = tokenizer.nextToken();
            until = tokenizer.nextToken();
            set = tokenizer.nextToken();
            if ("null".equals(set)) {
                set = null;
            }
            metadataPrefix = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
            if (metadataPrefix.equals("null")) {
                metadataPrefix = null;
            }
        }
        catch (NoSuchElementException e) {
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listIdentifiersMap = new HashMap<String, Object>();
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        try {
            Document srResponse;
            try {
                srResponse = this.getSearchRetrieveResponse(this.sruURL, from, until, set, "http://www.openarchives.org/OAI/2.0/#header", oldCount, this.maxListSize, "xml");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                throw new OAIInternalServerError(e.getMessage());
            }
            NodeList nodeList = this.getRecords(srResponse);
            if (nodeList != null) {
                RecordFactory recordFactory = this.getRecordFactory();
                int i = 0;
                while (i < nodeList.getLength()) {
                    Element rec = this.getRecordData(nodeList.item(i));
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("header", rec);
                    String localIdentifier = this.getRecordFactory().getLocalIdentifier(hashMap);
                    hashMap.put("metadata", this.getNativeMetadata(localIdentifier, metadataPrefix));
                    String[] header = recordFactory.createHeader(hashMap);
                    headers.add(header[0]);
                    identifiers.add(header[1]);
                    ++i;
                }
                if (this.getNumberOfRecords(srResponse) > oldCount + nodeList.getLength()) {
                    StringBuffer newResumptionToken = new StringBuffer();
                    newResumptionToken.append(from);
                    newResumptionToken.append(":");
                    newResumptionToken.append(until);
                    newResumptionToken.append(":");
                    newResumptionToken.append(set);
                    newResumptionToken.append(":");
                    newResumptionToken.append(metadataPrefix);
                    newResumptionToken.append(":");
                    newResumptionToken.append(oldCount + nodeList.getLength());
                    listIdentifiersMap.put("resumptionMap", this.getResumptionMap(newResumptionToken.toString()));
                }
            }
            listIdentifiersMap.put("headers", headers.iterator());
            listIdentifiersMap.put("identifiers", identifiers.iterator());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        return listIdentifiersMap;
    }

    public Vector getSchemaLocations(String oaiIdentifier) throws IdDoesNotExistException, NoMetadataFormatsException, OAIInternalServerError {
        Vector result = new Vector();
        NodeList nodeList = null;
        try {
            nodeList = this.getIdentifierRecords(this.sruURL, oaiIdentifier, null);
        }
        catch (Throwable e) {
            throw new OAIInternalServerError("Database failure");
        }
        if (nodeList != null) {
            int i = 0;
            while (i < nodeList.getLength()) {
                block11: {
                    try {
                        Element rec = this.getRecordData(nodeList.item(i));
                        if (rec != null) {
                            Vector schemaLocations = this.getRecordFactory().getSchemaLocations(rec);
                            int j = 0;
                            while (j < schemaLocations.size()) {
                                result.add(schemaLocations.get(j));
                                ++j;
                            }
                            break block11;
                        }
                        throw new OAIInternalServerError("Null Record");
                    }
                    catch (TransformerException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                }
                ++i;
            }
        } else {
            throw new IdDoesNotExistException(oaiIdentifier);
        }
        return result;
    }

    public String getRecord(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        Object nativeObject;
        try {
            nativeObject = this.getFullRecord(this.sruURL, oaiIdentifier, metadataPrefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        if (nativeObject != null) {
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            try {
                String s = this.getRecordFactory().create(nativeObject, schemaURL, metadataPrefix);
                return s;
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    public String getMetadata(String oaiIdentifier, String metadataPrefix) throws IdDoesNotExistException, IdDoesNotExistException, CannotDisseminateFormatException, OAIInternalServerError {
        Object nativeObject;
        try {
            nativeObject = this.getFullRecord(this.sruURL, oaiIdentifier, metadataPrefix);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        System.out.println(nativeObject);
        if (nativeObject != null) {
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                System.out.println("SRUOAICatalog.getRecord: metadataPrefix not found");
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            try {
                return this.getRecordFactory().createMetadata(nativeObject, schemaURL, metadataPrefix);
            }
            catch (CannotDisseminateFormatException e) {
                e.printStackTrace();
                throw e;
            }
        }
        throw new IdDoesNotExistException(oaiIdentifier);
    }

    private NodeList getIdentifierRecords(String sruURL, String oaiIdentifier, String metadataPrefix) throws TransformerException, SAXException, IOException, ParserConfigurationException {
        String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
        Document srResponse = this.getSearchRetrieveResponse(sruURL, localIdentifier, "http://www.openarchives.org/OAI/2.0/#header", "xml");
        return this.getRecords(srResponse);
    }

    private Object getFullRecord(String sruURL, String oaiIdentifier, String metadataPrefix) throws SAXException, TransformerException, IOException, ParserConfigurationException {
        NodeList nodeList = this.getIdentifierRecords(sruURL, oaiIdentifier, metadataPrefix);
        if (nodeList != null) {
            HashMap<String, Element> hashMap = new HashMap<String, Element>();
            hashMap.put("header", this.getRecordData(nodeList.item(0)));
            String nativeRecordSchema = this.getRecordFactory().getCrosswalks().getNativeRecordSchema(metadataPrefix);
            String localIdentifier = this.getRecordFactory().fromOAIIdentifier(oaiIdentifier);
            Document srResponse = this.getSearchRetrieveResponse(sruURL, localIdentifier, nativeRecordSchema, "xml");
            nodeList = this.getRecords(srResponse);
            hashMap.put("metadata", this.getRecordData(nodeList.item(0)));
            return hashMap;
        }
        return null;
    }

    private Object getNativeMetadata(String localIdentifier, String metadataPrefix) throws TransformerException, SAXException, IOException, ParserConfigurationException {
        String nativeRecordSchema = this.getRecordFactory().getCrosswalks().getNativeRecordSchema(metadataPrefix);
        Document srResponse = this.getSearchRetrieveResponse(this.sruURL, localIdentifier, nativeRecordSchema, "xml");
        NodeList nodeList = this.getRecords(srResponse);
        return this.getRecordData(nodeList.item(0));
    }

    public Map listRecords(String from, String until, String set, String metadataPrefix) throws BadArgumentException, CannotDisseminateFormatException, NoItemsMatchException, NoSetHierarchyException, OAIInternalServerError {
        Document srResponse;
        if (set != null && set.length() > 0 && from.equals(this.toFinestFrom("0000-00-00")) && until.equals(this.toFinestUntil("9999-99-99"))) {
            from = null;
            until = null;
        }
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> recordsList = new ArrayList<String>();
        try {
            srResponse = this.getSearchRetrieveResponse(this.sruURL, from, until, set, "http://www.openarchives.org/OAI/2.0/#header", 1, this.maxListSize, "xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        try {
            NodeList nodeList = this.getRecords(srResponse);
            if (nodeList != null) {
                RecordFactory recordFactory = this.getRecordFactory();
                String schemaURL = null;
                if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                    throw new CannotDisseminateFormatException(metadataPrefix);
                }
                int i = 0;
                while (i < nodeList.getLength()) {
                    Element rec = this.getRecordData(nodeList.item(i));
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("header", rec);
                    String localIdentifier = this.getRecordFactory().getLocalIdentifier(hashMap);
                    try {
                        hashMap.put("metadata", this.getNativeMetadata(localIdentifier, metadataPrefix));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                    catch (ParserConfigurationException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                    catch (SAXException e) {
                        e.printStackTrace();
                        throw new OAIInternalServerError(e.getMessage());
                    }
                    recordsList.add(recordFactory.create(hashMap, schemaURL, metadataPrefix));
                    ++i;
                }
                if (this.getNumberOfRecords(srResponse) > nodeList.getLength()) {
                    StringBuffer resumptionToken = new StringBuffer();
                    resumptionToken.append(from);
                    resumptionToken.append(":");
                    resumptionToken.append(until);
                    resumptionToken.append(":");
                    resumptionToken.append(set);
                    resumptionToken.append(":");
                    resumptionToken.append(metadataPrefix);
                    resumptionToken.append(":");
                    resumptionToken.append(nodeList.getLength());
                    listRecordsMap.put("resumptionMap", this.getResumptionMap(resumptionToken.toString()));
                }
            } else {
                throw new NoItemsMatchException();
            }
            listRecordsMap.put("records", recordsList.iterator());
            return listRecordsMap;
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public Map listRecords(String resumptionToken) throws BadResumptionTokenException, OAIInternalServerError {
        int oldCount;
        String metadataPrefix;
        String set;
        String until;
        String from;
        StringTokenizer tokenizer = new StringTokenizer(resumptionToken, ":");
        try {
            from = tokenizer.nextToken();
            until = tokenizer.nextToken();
            set = tokenizer.nextToken();
            if ("null".equals(set)) {
                set = null;
            }
            metadataPrefix = tokenizer.nextToken();
            oldCount = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
            throw new BadResumptionTokenException();
        }
        HashMap<String, Object> listRecordsMap = new HashMap<String, Object>();
        ArrayList<String> recordsList = new ArrayList<String>();
        try {
            Document srResponse = this.getSearchRetrieveResponse(this.sruURL, from, until, set, "http://www.openarchives.org/OAI/2.0/#header", oldCount, this.maxListSize, "xml");
            NodeList nodeList = this.getRecords(srResponse);
            RecordFactory recordFactory = this.getRecordFactory();
            String schemaURL = null;
            if (metadataPrefix != null && (schemaURL = this.getCrosswalks().getSchemaURL(metadataPrefix)) == null) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            int i = 0;
            while (i < nodeList.getLength()) {
                Element rec = this.getRecordData(nodeList.item(i));
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("header", rec);
                String localIdentifier = this.getRecordFactory().getLocalIdentifier(hashMap);
                hashMap.put("metadata", this.getNativeMetadata(localIdentifier, metadataPrefix));
                recordsList.add(recordFactory.create(hashMap, schemaURL, metadataPrefix));
                ++i;
            }
            if (this.getNumberOfRecords(srResponse) > oldCount + nodeList.getLength()) {
                StringBuffer newResumptionToken = new StringBuffer();
                newResumptionToken.append(from);
                newResumptionToken.append(":");
                newResumptionToken.append(until);
                newResumptionToken.append(":");
                newResumptionToken.append(set);
                newResumptionToken.append(":");
                newResumptionToken.append(metadataPrefix);
                newResumptionToken.append(":");
                newResumptionToken.append(oldCount + nodeList.getLength());
                listRecordsMap.put("resumptionMap", this.getResumptionMap(newResumptionToken.toString()));
            }
            listRecordsMap.put("records", recordsList.iterator());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new OAIInternalServerError("Database Failure");
        }
        return listRecordsMap;
    }

    private int getNumberOfRecords(Document srResponse) throws TransformerException {
        Node numberOfRecordsNode = XPathAPI.selectSingleNode((Node)srResponse, (String)"/srw:searchRetrieveResponse/srw:numberOfRecords", (Node)xmlnsEl);
        return Integer.parseInt(XPathAPI.eval((Node)numberOfRecordsNode, (String)"string()", (Node)xmlnsEl).str());
    }

    public void close() {
    }

    private Document getSearchRetrieveResponse(String sruURL, String from, String until, String set, String recordSchema, int startRecord, int maximumRecords, String recordPacking) throws SAXException, ParserConfigurationException, UnsupportedEncodingException, IOException {
        StringBuffer query = new StringBuffer();
        if (from != null && from.length() > 0 || until != null && until.length() > 0) {
            query.append("(");
            if (from != null && from.length() > 0) {
                query.append("oai.datestamp>=\"");
                query.append(this.normalizeTerm(from));
                query.append("\"");
            }
            if (until != null && from.length() > 0) {
                if (query.length() > 0) {
                    query.append(" and ");
                }
                query.append("oai.datestamp<=\"");
                query.append(this.normalizeTerm(until));
                query.append("\"");
            }
            query.append(")");
        }
        if (set != null && set.length() > 0) {
            if (query.length() > 0) {
                query.append(" and ");
            }
            query.append("oai.set=\"");
            query.append(this.normalizeTerm(set));
            query.append("\"");
        }
        StringBuffer request = new StringBuffer(sruURL);
        request.append("?operation=searchRetrieve&version=1.1&query=");
        request.append(URLEncoder.encode(query.toString(), "UTF-8"));
        request.append("&recordSchema=").append(URLEncoder.encode(recordSchema, "UTF-8"));
        request.append("&startRecord=").append(Integer.toString(startRecord));
        request.append("&maximumRecords=").append(Integer.toString(maximumRecords));
        request.append("&recordPacking=").append(recordPacking);
        request.append("&sortKeys=").append(URLEncoder.encode(this.sortKeys, "UTF-8"));
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(request.toString());
    }

    private Document getSearchRetrieveResponse(String sruURL, String localIdentifier, String recordSchema, String recordPacking) throws SAXException, IOException, ParserConfigurationException, UnsupportedEncodingException {
        StringBuffer query = new StringBuffer();
        query.append("oai.identifier exact \"");
        query.append(localIdentifier);
        query.append("\"");
        StringBuffer request = new StringBuffer(sruURL);
        request.append("?operation=searchRetrieve&version=1.1&query=");
        request.append(URLEncoder.encode(query.toString(), "UTF-8"));
        request.append("&recordSchema=").append(URLEncoder.encode(recordSchema, "UTF-8"));
        request.append("&startRecord=1&maximumRecords=1");
        request.append("&recordPacking=").append(recordPacking);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(request.toString());
    }

    private Element getRecordData(Node record) throws TransformerException, SAXException, IOException {
        Node result = XPathAPI.selectSingleNode((Node)record, (String)"srw:recordData/*[1]", (Node)xmlnsEl);
        return this.toDocument((Element)result).getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document toDocument(Element el) throws TransformerException, SAXException, IOException {
        DOMSource source = new DOMSource(el);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        Transformer transformer = SRUOAICatalog.transformer;
        synchronized (transformer) {
            SRUOAICatalog.transformer.transform(source, result);
        }
        Document doc = builder.parse(new InputSource(new StringReader(sw.toString())));
        Element docEl = doc.getDocumentElement();
        if (docEl.getNamespaceURI() == null) {
            docEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        return doc;
    }

    private NodeList getRecords(Document srResponse) throws TransformerException {
        return XPathAPI.selectNodeList((Node)srResponse, (String)"/srw:searchRetrieveResponse/srw:records/srw:record", (Node)xmlnsEl);
    }

    static {
        try {
            transformer = transformerFactory.newTransformer();
            factory.setNamespaceAware(true);
            builder = factory.newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            Document xmlnsDoc = impl.createDocument("http://www.oclc.org/research/software/oai/harvester", "harvester:xmlnsDoc", null);
            xmlnsEl = xmlnsDoc.getDocumentElement();
            xmlnsEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:srw", "http://www.loc.gov/zing/srw/");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

