/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.crosswalk;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class FileMap2oai_dc
extends Crosswalk {
    private Transformer transformer = null;

    public FileMap2oai_dc(Properties properties) throws OAIInternalServerError {
        super("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
        try {
            String xsltName = properties.getProperty("FileMap2oai_dc.xsltName");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (xsltName != null) {
                StreamSource xslSource = new StreamSource(new FileInputStream(xsltName));
                this.transformer = tFactory.newTransformer(xslSource);
            } else {
                this.transformer = tFactory.newTransformer();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAIInternalServerError(e.getMessage());
        }
    }

    public boolean isAvailableFor(Object nativeItem) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createMetadata(Object nativeItem) throws CannotDisseminateFormatException {
        HashMap recordMap = (HashMap)nativeItem;
        try {
            String xmlRec = new String((byte[])recordMap.get("recordBytes"), "UTF-8").trim();
            if (xmlRec.startsWith("<?")) {
                int offset = xmlRec.indexOf("?>");
                xmlRec = xmlRec.substring(offset + 2);
            }
            StringReader stringReader = new StringReader(xmlRec);
            StreamSource streamSource = new StreamSource(stringReader);
            StringWriter stringWriter = new StringWriter();
            Transformer transformer = this.transformer;
            synchronized (transformer) {
                this.transformer.transform(streamSource, new StreamResult(stringWriter));
            }
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new CannotDisseminateFormatException(e.getMessage());
        }
    }
}

