/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

public class GetRecord
extends ServerVerb {
    private static final boolean debug = false;
    private static ArrayList validParamNames = new ArrayList();

    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws OAIInternalServerError, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String identifier = request.getParameter("identifier");
        String metadataPrefix = request.getParameter("metadataPrefix");
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        String styleSheet = properties.getProperty("OAIHandler.styleSheet");
        if (styleSheet != null) {
            sb.append("<?xml-stylesheet type=\"text/xsl\" href=\"");
            sb.append(styleSheet);
            sb.append("\"?>");
        }
        sb.append("<OAI-PMH xmlns=\"http://www.openarchives.org/OAI/2.0/\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/");
        sb.append(" http://www.openarchives.org/OAI/2.0/OAI-PMH.xsd\">");
        sb.append("<responseDate>");
        sb.append(ServerVerb.createResponseDate(new Date()));
        sb.append("</responseDate>");
        Crosswalks crosswalks = abstractCatalog.getCrosswalks();
        try {
            if (metadataPrefix == null || metadataPrefix.length() == 0 || identifier == null || identifier.length() == 0 || ServerVerb.hasBadArguments(request, validParamNames.iterator(), validParamNames)) {
                throw new BadArgumentException();
            }
            if (!crosswalks.containsValue(metadataPrefix)) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            String record = abstractCatalog.getRecord(identifier, metadataPrefix);
            if (record == null) {
                throw new IdDoesNotExistException(identifier);
            }
            sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL));
            sb.append("<GetRecord>");
            sb.append(record);
            sb.append("</GetRecord>");
        }
        catch (BadArgumentException e) {
            sb.append("<request verb=\"GetRecord\">");
            sb.append(baseURL);
            sb.append("</request>");
            sb.append(e.getMessage());
        }
        catch (CannotDisseminateFormatException e) {
            sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL));
            sb.append(e.getMessage());
        }
        catch (IdDoesNotExistException e) {
            sb.append(ServerVerb.getRequestElement(request, validParamNames, baseURL));
            sb.append(e.getMessage());
        }
        sb.append("</OAI-PMH>");
        return ServerVerb.render(response, "text/xml; charset=UTF-8", sb.toString(), serverTransformer);
    }

    static {
        validParamNames.add("verb");
        validParamNames.add("identifier");
        validParamNames.add("metadataPrefix");
    }
}

