/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.verb.extension;

import ORG.oclc.oai.server.catalog.AbstractCatalog;
import ORG.oclc.oai.server.crosswalk.Crosswalks;
import ORG.oclc.oai.server.verb.BadArgumentException;
import ORG.oclc.oai.server.verb.BadVerb;
import ORG.oclc.oai.server.verb.CannotDisseminateFormatException;
import ORG.oclc.oai.server.verb.IdDoesNotExistException;
import ORG.oclc.oai.server.verb.OAIInternalServerError;
import ORG.oclc.oai.server.verb.ServerVerb;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;

public class GetMetadata
extends ServerVerb {
    private static final boolean debug = false;
    private static ArrayList validParamNames = new ArrayList();

    public static String construct(HashMap context, HttpServletRequest request, HttpServletResponse response, Transformer serverTransformer) throws FileNotFoundException, TransformerException {
        Properties properties = (Properties)context.get("OAIHandler.properties");
        AbstractCatalog abstractCatalog = (AbstractCatalog)context.get("OAIHandler.catalog");
        String baseURL = properties.getProperty("OAIHandler.baseURL");
        if (baseURL == null) {
            try {
                baseURL = request.getRequestURL().toString();
            }
            catch (NoSuchMethodError f) {
                baseURL = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            }
        }
        StringBuffer sb = new StringBuffer();
        String identifier = request.getParameter("identifier");
        String metadataPrefix = request.getParameter("metadataPrefix");
        Crosswalks crosswalks = abstractCatalog.getCrosswalks();
        sb.append("<?xml version=\"1.0\" encoding=\"");
        String encoding = crosswalks.getEncoding(metadataPrefix);
        if (encoding != null) {
            sb.append(encoding);
        } else {
            sb.append("UTF-8");
        }
        sb.append("\" ?>\n");
        String docType = crosswalks.getDocType(metadataPrefix);
        if (docType != null) {
            sb.append(docType);
            sb.append("\n");
        }
        try {
            if (metadataPrefix == null || metadataPrefix.length() == 0 || identifier == null || identifier.length() == 0) {
                throw new BadArgumentException();
            }
            if (!crosswalks.containsValue(metadataPrefix)) {
                throw new CannotDisseminateFormatException(metadataPrefix);
            }
            String metadata = abstractCatalog.getMetadata(identifier, metadataPrefix);
            if (metadata == null) {
                throw new IdDoesNotExistException(identifier);
            }
            sb.append(metadata);
        }
        catch (BadArgumentException e) {
            throw new FileNotFoundException();
        }
        catch (CannotDisseminateFormatException e) {
            throw new FileNotFoundException();
        }
        catch (IdDoesNotExistException e) {
            throw new FileNotFoundException();
        }
        catch (OAIInternalServerError e) {
            e.printStackTrace();
            return BadVerb.construct(context, request, response, serverTransformer);
        }
        return ServerVerb.render(response, crosswalks.getContentType(metadataPrefix), sb.toString(), null);
    }

    static {
        validParamNames.add("verb");
        validParamNames.add("identifier");
        validParamNames.add("metadataPrefix");
    }
}

