package org.injac.oai.ihm;

import org.apache.log4j.Logger;
import org.injac.oai.util.XMLStreamParser;
import org.injac.oai.util.XSLTransformer;
import org.injac.oai.ihm.Verbs;
import java.io.*;
import java.util.*;
import javax.servlet.http.HttpServletRequest;

public class OAIHTMLMenu {
	/**
	 * Document to parse
	 */
	static Logger logger = Logger.getLogger(OAIHTMLMenu.class);

	private String realPath;
	private String baseURL;
	private InputStream streamSets;
	private InputStream streamFormats;
	private String xmlSets = null;
	private String xmlFormats = null;
	private ArrayList verbList = null;
	
	public String getXmlFormats() {
		return xmlFormats;
	}
	public String getXmlSets() {
		return xmlSets;
	}
	/** Constructor for OAIHTMLMenu
	 * 
	 * @param realPath : path to directory for xsl files
	 * @param baseURL : URL for OAI storage
	 */
	public OAIHTMLMenu(String realPath, String baseURL){
		this.realPath =realPath;
		if(! this.realPath.endsWith(File.separator)){
			this.realPath+=File.separator;
		}
		this.baseURL =baseURL;
		init();
	}
	/**
	 * init listsets and listmetadataformats as stream and string
	 *
	 */
	private void init(){
		String OAIrequest = baseURL+"?verb=ListSets";
		XMLStreamParser parser = new XMLStreamParser();
		streamSets= parser.getStreamFromURL(OAIrequest);
		xmlSets= parser.getStringFromURL(OAIrequest);
		OAIrequest = baseURL+"?verb=ListMetadataFormats";
		streamFormats= parser.getStreamFromURL(OAIrequest);
		xmlFormats= parser.getStringFromURL(OAIrequest);
		
		verbList = new ArrayList();
		for(int i=0;i<Verbs.verbs.length;i++){
			verbList.add(Verbs.verbs[i]);
		}

	}
	
	public void setOAIParametersFromRequest(XSLTransformer xslt, HttpServletRequest request){
		String params[] = Verbs.allParams.split(" ");
		for(int i=0;i<params.length;i++ ){
			String paramName = params[i];
			String paramValue= request.getParameter(paramName);
			if(paramValue!=null)
				xslt.setParameter(paramName, paramValue);
		}
		
	}
	
	public String getHTMLFromStream(String xsltFile, InputStream stream){
		String html="";
		XSLTransformer xslt = new XSLTransformer(realPath+xsltFile);
		html = xslt.transform(stream);
		return html;
	}
	/**
	 * Produces HTML code for ListSets and ListMetadatFormats OAI verbs
	 * @param xsltFile : stylesheet for HTML rendering
	 * @return HTML code as String
	 */
	public String getListsMenu(String xsltFile, int index, String listVerb, HttpServletRequest request){
		String html="";
		XSLTransformer xslt = new XSLTransformer(realPath+xsltFile);
		xslt.setParameter("index", ""+index);
		xslt.setParameter("listVerb", listVerb);
		setOAIParametersFromRequest(xslt, request);
		html += xslt.transform(streamSets);
		html += xslt.transform(streamFormats);
		return html;
	}
	

	//verbs={"Identify", "ListMetadataFormats", "ListSets", "ListRecords", "ListIdentifiers","GetRecord"};
	public String getOAIRequestForm(String xsltFile, String verb, HttpServletRequest request){
		String reqHTML="";
		String xmlReq= "<?xml version=\"1.0\" encoding=\"utf-8\" ?>";
		xmlReq += "<merge>"+getVerbs(verb);;
		int iverb= verbList.indexOf(verb);
		switch(iverb){
		case 0:
		case 1:
		case 2:
			break;	
		case 3:
			xmlReq +=  "<FromUntil/>" + getXmlSetsAndFormatsInclude();
			break;
		case 4:
			xmlReq +=  "<FromUntil/>" + getXmlSetsAndFormatsInclude();
			break;
		case 5:
			xmlReq +=  "<Identifier/>" + getXmlFormatsInclude();
			break;	
		default:
			break;
		}
		xmlReq += "</merge>";
		XSLTransformer xslt = new XSLTransformer(realPath +xsltFile);
		setOAIParametersFromRequest(xslt, request);
		reqHTML = xslt.transform(xmlReq);
		return reqHTML;
	}	
	public String getXmlSetsAndFormatsInclude(){	
		String setsToMerge="";
		String formatsToMerge ="";
		int start = xmlSets.indexOf("<ListSets>");
		int end = xmlSets.indexOf("</OAI-PMH>");
		if(start!=-1 && end!=-1){
			setsToMerge = xmlSets.substring(start,end);	
		}else{
			logger.error("bad xml for sets : " + xmlSets);
		}
		start = xmlFormats.indexOf("<ListMetadataFormats>");
		end = xmlFormats.indexOf("</OAI-PMH>");
		if(start!=-1 && end!=-1){
			formatsToMerge = xmlFormats.substring(start,end);	
		}else{
			logger.error("bad xml for formats : " + xmlFormats);
		}
		String xmlReq = setsToMerge+formatsToMerge;
		return xmlReq;
	}
	public String getXmlFormatsInclude(){	
		int start = xmlFormats.indexOf("<ListMetadataFormats>");
		int end = xmlFormats.indexOf("</OAI-PMH>");
		String formatsToMerge = xmlFormats.substring(start,end);
		String xmlReq =formatsToMerge;
		return xmlReq;
	}
	public String getVerbs(String selected){
		String xmlReq="<verbs value=\""+selected+"\">";
		for(int i=0;i<verbList.size();i++){
			xmlReq += "<verb>"+(String)verbList.get(i)+"</verb>"; 
		}
		xmlReq += "</verbs>";
		return xmlReq;
	}

}
