package org.injac.oai.ihm;
import java.util.*;
import javax.servlet.http.HttpServletRequest;
public class Verbs {
	public static String[] verbs={"Identify", "ListMetadataFormats", "ListSets", "ListRecords", "ListIdentifiers","GetRecord"};
	public static String allParams = "from until metadataPrefix set identifier resumptionToken";
	public static String[] verbsparams={"", 
								"",
								"",
								"from until metadataPrefix set resumptionToken", 
								"from until metadataPrefix set resumptionToken", 
								"identifier metadataPrefix"};
	private HashMap verbMap;
	public Verbs(){
		verbMap = new HashMap();
		for(int i=0;i<verbs.length;i++){
			String[] params = verbsparams[i].split("\\s");
			verbMap.put(verbs[i], params);
		}
		
	}
	public String[] getParams(String verb){
		return (String[])verbMap.get(verb);
	}
	public String getOAIParamsFromRequest(HttpServletRequest request){
		String verb= request.getParameter("verb");
		if(verb==null)
			return "";
		String[] params = (String[])verbMap.get(verb);
		String result = "verb="+verb;
		for(int i=0;i<params.length;i++){
			String value = request.getParameter(params[i]);
			if(value!=null){
				result+="&"+params[i]+"="+value;
			}
		}
		return result;
		
	}
	
}
