/*
 * Created on 22 avr. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.catalog;

/**
 * @author shoam
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

import org.w3c.dom.Element;
import org.injac.oai.server.OAIBadConfigurationException;
import org.injac.oai.server.crosswalk.CrosswalkHashMap;
import org.oclc.oai.server.catalog.RecordFactory;
import org.oclc.oai.server.crosswalk.Crosswalks;
import org.oclc.oai.server.verb.BadArgumentException;


/**
 * XMLFileRecordFactory converts native XML "items" to "record" Strings.
 * This factory assumes the native XML item looks exactly like the <record>
 * element of an OAI GetRecord response, with the possible exception that the
 * <metadata> element contains multiple metadataFormats from which to choose.
 */
public class WebdavRecordFactory extends RecordFactory {
     private String repositoryIdentifier = null;
	
    /**
     * Construct an WebdavRecordFactory capable of producing the Crosswalk(s)
     * specified in the properties file.
     * @param properties Contains information to configure the factory:
     *                   specifically, the names of the crosswalk(s) supported
     * @exception IllegalArgumentException Something is wrong with the argument.
     */
    public WebdavRecordFactory(Properties properties)
	throws IllegalArgumentException, OAIBadConfigurationException {
    
    // call constructor with Crosswalk HashMap
    super(new CrosswalkHashMap(properties));
 	repositoryIdentifier = properties.getProperty("WebdavRecordFactory.repositoryIdentifier");
 	if (repositoryIdentifier == null) {
 	    throw new IllegalArgumentException("WebdavRecordFactory.repositoryIdentifier is missing from the properties file");
 	}
    }

    /**
     * Utility method to parse the 'local identifier' from the OAI identifier
     *
     * @param identifier OAI identifier (e.g. oai:oaicat.oclc.org:ID/12345)
     * @return local identifier (e.g. ID/12345).
     */
    public String fromOAIIdentifier(String identifier) {
        try {
//             StringTokenizer tokenizer = new StringTokenizer(identifier, ":");
//             tokenizer.nextToken();
//             tokenizer.nextToken();
//             return tokenizer.nextToken();
            return IDConverter.fromOAIIdentifier(identifier);
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * Construct an OAI identifier from the native item
     *
     * @param nativeItem native Item object
     * @return OAI identifier
     */
    public String getOAIIdentifier(Object nativeItem) {
	
	return IDConverter.getOAIIdentifier(nativeItem, repositoryIdentifier); 
    }

    /**
     * Extract the local identifier from the native item
     *
     * @param nativeItem native Item object
     * @return local identifier
     */
    public String getLocalIdentifier(Object nativeItem) {
        return IDConverter.getLocalIdentifier(nativeItem);
    }

    /**
     * get the datestamp from the item
     *
     * @param nativeItem a native item presumably containing a datestamp somewhere
     * @return a String containing the datestamp for the item
     * @exception IllegalArgumentException Something is wrong with the argument.
     */
    public String getDatestamp(Object nativeItem)
	throws IllegalArgumentException  {
    	return (String)((HashMap)nativeItem).get("datestamp");
    }

    /**
     * get the setspec from the item
     *
     * @param nativeItem a native item presumably containing a setspec somewhere
     * @return a String containing the setspec for the item
     * @exception IllegalArgumentException Something is wrong with the argument.
     */
    public Iterator getSetSpecs(Object nativeItem)
	throws IllegalArgumentException  {
    	try{
    		Object o=((HashMap)nativeItem).get("setSpecs");
    		List setSpecs = (List)o;
    		if (setSpecs != null) 
    			return setSpecs.iterator();
    		else
    			return null;
    	}catch(Exception e)
		{
    		return null;
		}
       
    }

    /**
     * Get the about elements from the item
     *
     * @param nativeItem a native item presumably containing about information somewhere
     * @return a Iterator of Strings containing &lt;about&gt;s for the item
     * @exception IllegalArgumentException Something is wrong with the argument.
     */
    public Iterator getAbouts(Object nativeItem) throws IllegalArgumentException {
	return null;
    }

    /**
     * Is the record deleted?
     *
     * @param nativeItem a native item presumably containing a possible delete indicator
     * @return true if record is deleted, false if not
     * @exception IllegalArgumentException Something is wrong with the argument.
     */
    public boolean isDeleted(Object nativeItem)
	throws IllegalArgumentException {
	return false;
    }

    /**
     * Allows classes that implement RecordFactory to override the default create() method.
     * This is useful, for example, if the entire &lt;record&gt; is already packaged as the native
     * record. Return null if you want the default handler to create it by calling the methods
     * above individually.
     * 
     * @param nativeItem the native record
     * @param schemaURL the schemaURL desired for the response
     * @param the metadataPrefix from the request
     * @return a String containing the OAI &lt;record&gt; or null if the default method should be
     * used.
     */
    public String quickCreate(Object nativeItem, String schemaLocation, String metadataPrefix) {
	// Don't perform quick creates
	return null;
    }
}
