/*
 * Created on 9 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.catalog.set;

import java.util.ArrayList;
import java.util.Vector;

/**
 * Class SetMatcher : 
 * Class identifying set from attributes matching with regular expressions 
 * Matching are defined in setSpecs.xml file
 * @author Franois Jannin june 2004
 *
 * 
 */
public class SetMatcher {
	/**
	 * type of match : any-of or all-of
	 */
	private String match;
	private Vector matchers;
	private String setSpec;
	public SetMatcher(String setSpec, String match){
		this.match = match;
		this.setSpec = setSpec;
		matchers = new Vector();
	}
	public void addWebdavMatcher(WebdavMatcher matcher) {
		matchers.add(matcher);
	}
	
	/**
	 * 
	 * @param nativeItem
	 * @return a string containing setSpec if a match occurs, null otherwise
	 */
	public String getSetSpec(Object nativeItem){
		java.util.HashMap map = (java.util.HashMap)nativeItem;
		boolean test = false;
		for(int i=0;i < matchers.size(); i++)
		{
			WebdavMatcher matcher= (WebdavMatcher)matchers.get(i);
			boolean anyof = match.equals("any-of");
			String value = (String) map.get(matcher.getTagName());
			if(value != null)
				test = matcher.exec(value);
			// exit on first match if any-of
			if(test && anyof)
				return setSpec;
			// ...otherwise if not anyof exit with null on first non-match 
			else if(!test && !anyof)
				return null;
		}
		// all-of ending case
		return test ? setSpec : null;
		
	}
}
