/*
 * Created on 9 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.catalog.set;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


/**
 * @author shoam
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class SetMatcherFactory {
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(SetMatcherFactory.class);
	
	public SetMatcherFactory(){}
	public ArrayList createSetMatchers(File setFile){
		ArrayList setMatchers = parseFile(setFile);
		//setMatcher.addWebdavMatcher(new WebdavMatcher("injac:keywords", true, ",", "info"));
		//setMatchers.add(setMatcher);
		return setMatchers;
	}

	private ArrayList parseFile(File setFile) {
	
		// Create DocumentBuilderFactory  
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		// 	Configure it to ignore comments
		//factory.setIgnoringComments(true);
		String [] setSpecs = new String[] {""};
		ArrayList matcherList = new ArrayList();
		Document doc;
		
		// 	Create the builder and doc
		try{
			//   Load the specified XML document
			DocumentBuilder builder = factory.newDocumentBuilder();
			doc = builder.parse(setFile);
			//setMatcher = setMatcher
		}catch(Exception e)
		{
			logger.error("SetMatcherFactory::parseFile  "+e.getClass().getName()+" : "+e.getMessage());
			return matcherList;
		}
		// parse the file
		try {
    	//Element el =doc.getDocumentElement();
			NodeList setNodes = doc.getElementsByTagName("set");
			for(int nodeIndex = 0; nodeIndex < setNodes.getLength();nodeIndex++)
			{
				Node curResultNode = setNodes.item(nodeIndex);
				Element el=(Element)curResultNode;
				String tagName = el.getTagName();
				logger.debug("Element :" + tagName);
				// 	read setSpec value for set node
				String setSpec = el.getElementsByTagName("setSpec").item(0).getFirstChild().getNodeValue();
				if(setSpec == null)
					throw new ParseException("no setSpec element found", 0);
        	// Retrieve infos from match info node to build matcher object
				SetMatcher setMatcher= parseMatchNode(setSpec, (Element)el.getElementsByTagName("metadata-matching").item(0));
				if(setMatcher != null)
					matcherList.add(setMatcher);
			}	
			return matcherList;
		}catch(Exception e)
		{
			logger.error("SetMatcherFactory::parseFile "+e.getClass().getName()+" : "+e.getMessage());
			return matcherList;
		}
	
	}

	private SetMatcher parseMatchNode(String setSpec, Element matchInfoNode) {
		if(matchInfoNode == null)
			return null;
		String match = matchInfoNode.getAttribute("match");
		try {
			SetMatcher setMatcher = new SetMatcher(setSpec,match);
			NodeList webdavNodes = matchInfoNode.getElementsByTagName("webdav-attr");
			if(webdavNodes==null)
				throw new ParseException("no webdav-attr elements found.", 0);
			// extract infos from each node to build WebdavMatcher(s)
			for(int nodeIndex = 0; nodeIndex < webdavNodes.getLength();nodeIndex++)
			{
				Element webdavattr = (Element)webdavNodes.item(nodeIndex);
				String name = webdavattr.getAttribute("name");
				String multivalue = webdavattr.getAttribute("multivalue");
				String delimiter = webdavattr.getAttribute("delimiter");
				String regexp = webdavattr.getElementsByTagName("match-regexp").item(0).getFirstChild().getNodeValue();
				WebdavMatcher webdavMatcher = new WebdavMatcher(name, multivalue.equals("true"), delimiter, regexp);
				setMatcher.addWebdavMatcher(webdavMatcher);
			}
			return setMatcher;
		}catch(Exception e)
		{
			logger.error("SetMatcherFactory::parseFile "+e.getClass().getName()+" : "+e.getMessage());
			return null;
		}
	}
	
}