/*
 * Created on 9 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.catalog.set;

import java.util.regex.*;

import org.apache.log4j.Logger;
/**
 *  WebdavMatcher class : 
 *  Match a webdav attribute defined by tagname parameter,to regexp parameter, regular expression
 * 
 *  @author Franois Jannin june 2004
 *  
 */
public class WebdavMatcher {
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(WebdavMatcher.class);
	/**
	 * Webdav attribute to match with
	 */
	private String tagname;
	/**
	 * Multivalue attribute
	 */
	private boolean mulitvalue;
	/**
	 * delimiter for tokenizing multivalue attribute
	 */
	private String delimiter;
	/**
	 * Regular expression to match 
	 */
	private String regexp;
	
	public WebdavMatcher(String tagname, boolean multivalue, String delimiter, String regexp){
		this.tagname = tagname;
		this.mulitvalue = multivalue;
		this.delimiter = delimiter;
		this.regexp = regexp;
	}
	public String getTagName(){
		return tagname;
	}
	/**
	 * Test a value against a regular expression
	 * @param value
	 * @return
	 */
	public boolean exec(String value){
		boolean found=false;
		Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(value);
		
        if(matcher.find()) {
            logger.debug("found \"" + matcher.group() +
                               "\" starting at index " + matcher.start() +
                               " and ending at index " + matcher.end() + ".");
            found = true;
        }
        return found;
	}
}
