/*
 * Created on 20 mai 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.crosswalk;

import java.io.File;
import java.util.HashMap;
import java.util.Properties;
import java.util.ArrayList;
import java.util.StringTokenizer;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.injac.oai.server.OAIBadConfigurationException;
import org.injac.oai.server.catalog.WebdavOAICatalog;
import org.oclc.oai.server.crosswalk.CrosswalkItem;
import org.oclc.oai.server.verb.OAIInternalServerError;

/**
 * @author F.Jannin
 *
 * Hashmap autofilling with Crosswalkitems extracted from properties
 * @param properties 
 */
public class CrosswalkHashMap extends HashMap {
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(CrosswalkHashMap.class);
	/**
	 * Construct a HashMap 
	 * @param properties
	 * @throws OAIBadConfigurationException
	 */
	public CrosswalkHashMap(Properties properties)throws OAIBadConfigurationException
	{
		String mapFiles = properties.getProperty("Injac.Crosswalk.mapFiles");
		String mapDir = properties.getProperty("Injac.Crosswalk.mapDir");
		
		
		if((null == mapFiles) || (null == mapDir))
			throw new OAIBadConfigurationException("Injac.Crosswalk.mapFiles and Injac.Crosswalk.mapDir must be set in propeties file.");
		if(!mapDir.endsWith("/"))
			mapDir+="/";
		StringTokenizer st = new StringTokenizer(mapFiles, ",");
		logger.debug("mapDir : "+mapDir);
		int count=0;
		while(st.hasMoreElements())
		{
			String file = st.nextToken();
			logger.debug("mapFile "+count+" : "+file);
			addCrossItemFromFile(mapDir+file);
			count++;
		}
		
	}
	private void addCrossItemFromFile(String formatfile)
	{
		
		//   Setting a system property required by SAXON
        //System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.icl.saxon.om.DocumentBuilderFactoryImpl");

        //   Create DocumentBuilderFactory  
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        
        // Configure it to ignore comments
        //factory.setIgnoringComments(true);
        
        String metadataPrefix=null;
		String schema=null;
		String metadataNamespace=null;
		// Create the builder and parse the file
        try{
        	//   Load the specified XML document
        	DocumentBuilder builder = factory.newDocumentBuilder();
        	
        	Document doc = builder.parse(new File(formatfile));
        	Element el =doc.getDocumentElement();
        	// get schema location
        	schema = el.getAttribute("schema"); 
        	metadataPrefix= el.getAttribute("metadata-prefix"); 
        	metadataNamespace= el.getAttribute("metadata-namespace"); 
       
        }catch(Exception ex)
		{
        	logger.error("addCrossItemFromFile : properties parsing error from " + formatfile+"\n"+ex.getLocalizedMessage());
		}
		
		
		try {
			// create crosswalk
			WebdavCrosswalk crosswalk= new WebdavCrosswalk(formatfile, schema);
			logger.debug("create crosswalk : "+ schema +"\nfrom "+formatfile);
			// add it in hashmap
			CrosswalkItem crossItem = new CrosswalkItem(metadataPrefix,schema, metadataNamespace,  crosswalk );
			this.put(metadataPrefix, crossItem);
			logger.debug("CrosswalkItem added for : "+ metadataPrefix);
		}catch(OAIInternalServerError ex)
		{
			logger.error("Unable to create crosswalk :" +ex);
		}
	}
}
