/*
 * Created on 29 juin 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.crosswalk;
import org.apache.log4j.Logger;
import org.injac.oai.util.OAITags;
import org.w3c.dom.*;


import java.util.*;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
/**
 * Class for metadata output
 * @author shoam
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class MetadataDocument {
	/**
	 * Static logger
	 */
	static Logger logger = Logger.getLogger(MetadataDocument.class);
	/**
	 * Root tag for metadata output document
	 */
	private String rootTag;
	/**
	 * Prefix for root element
	 */
	private String prefix;
	/**
	 * Namespace for root element
	 */
	private String namespace;
	/**
	 * prefixes + uris for optionnal prefix/namespaces 
	 */
	private HashMap otherNS;
	/**
	 *  Schema location for this metadata format
	 */
	private String schema;
	/**
	 * DOM document 
	 */
	private Document document=null;

	public MetadataDocument(String rootTag,String  metadataPrefix,String  metadataNamespace,String  schema, HashMap nameSpaces){
		
		this.rootTag = rootTag;
		this.prefix = metadataPrefix;
		this.namespace = metadataNamespace;
		this.otherNS = nameSpaces;
		this.schema = schema;
    	init();
    	
    	
    	
	}
	/**
	 * Build a doc from whole cloth with root tag and xmlns declarations
	 *
	 */
	private void init(){
		  DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
	      document=null;
	        try {
	          DocumentBuilder builder = factory.newDocumentBuilder();
	          document = builder.newDocument();  // Create from whole cloth
	          Element root = (Element) document.createElement(prefix+":"+rootTag); 
	          logger.debug("MetaDataDocument::init : \nrooTag : "+rootTag+"\nprefix :"+prefix+"\nnamespace : "+namespace);
	          root.setAttribute("xmlns:"+prefix, namespace);
	          //root.setPrefix(prefix);
	          Iterator keys = otherNS.keySet().iterator();
	          while(keys.hasNext())
	          {	
	          	String other_prefix = (String)keys.next();
	          	String other_namespace=(String)otherNS.get(other_prefix);
	          	root.setAttribute("xmlns:"+other_prefix, other_namespace);
	          }
	          root.setAttribute("xmlns:xsi", OAITags.XSI_XMLNS);
	          root.setAttribute("xsi:schemaLocation", schema);	
	          
	          document.appendChild(root);
	          //root.appendChild( document.createTextNode("Some Text") );
	        } catch (ParserConfigurationException pce) {
	            // Parser with specified options can't be built
	            pce.printStackTrace();
	        }
	}
	public Document getDocument(){
		return document;
	}
	/**
	 * Clear all nodes from document, just root element left
	 *
	 */
	public void clear(){
		Element root = document.getDocumentElement();
		NodeList childs = root.getChildNodes();
		for(int i =0; i< childs.getLength();i++)
				root.removeChild(childs.item(i));
		
		int rest = childs.getLength();
	}
}
