/*
 * Created on 22 avr. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.oai.server.crosswalk;

/**
 * @author shoam
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */



import java.util.Properties;
import java.util.Enumeration;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.oclc.oai.server.crosswalk.Crosswalk;
import org.oclc.oai.server.verb.CannotDisseminateFormatException;


/**
 * Convert native "item" to oai_dc. In this case, the native "item"
 * is assumed to already be formatted as an OAI <record> element,
 * with the possible exception that multiple metadataFormats may
 * be present in the <metadata> element. The "crosswalk", merely
 * involves pulling out the one that is requested.
 */
public class Webdav2oai_dc extends Crosswalk {
    private static final String elementName = "oai_dc:dc";
    private static final String elementStart = "<" + elementName;
    private static final String elementEnd = elementName + ">";
	private String webdavpath = null;
    /**
     * The constructor assigns the schemaLocation associated with this crosswalk. Since
     * the crosswalk is trivial in this case, no properties are utilized.
     *
     * @param properties properties that are needed to configure the crosswalk.
     */
    public Webdav2oai_dc(Properties properties) {
    	
	super("http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd");
	webdavpath=properties.getProperty("WebdavOAICatalog.url");
    }

    /**
     * Can this nativeItem be represented in DC format?
     * @param nativeItem a record in native format
     * @return true if DC format is possible, false otherwise.
     */
    public boolean isAvailableFor(Object nativeItem) {
	
	if (nativeItem != null)
	    return true;
	return false;
    }

    /**
     * Perform the actual crosswalk.
     *
     * @param nativeItem the native "item". In this case, it is
     * already formatted as an OAI <record> element, with the
     * possible exception that multiple metadataFormats are
     * present in the <metadata> element.
     * @return a String containing the XML to be stored within the <metadata> element.
     * @exception CannotDisseminateFormatException nativeItem doesn't support this format.
     */
    public String createMetadata(Object nativeItem)
	throws CannotDisseminateFormatException {
    	String xmlns = " xmlns:oai_dc=\"http://www.openarchives.org/OAI/2.0/oai_dc/\""; 
    	xmlns+=" xmlns:dc=\"http://purl.org/dc/elements/1.1/\""; 
    	xmlns+=" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""; 
    	xmlns+=" xsi:schemaLocation=\"http://www.openarchives.org/OAI/2.0/oai_dc/ http://www.openarchives.org/OAI/2.0/oai_dc.xsd\"";
    	String result = "<"+elementName+xmlns+">";//getSchemaLocation();
    	
    	HashMap hash = (HashMap)nativeItem;
    	String S=null;
    	
    	
    	try {
    			// TODO : xml map file
    			S = (String)hash.get("title");
				result+="<dc:title>"+S+"</dc:title>";
				S = (String)hash.get("author");
				result+="<dc:creator>"+S+"</dc:creator>";
				S = (String)hash.get("co-author");
				if(!S.equals(""))
					result+="<dc:creator>"+S+"</dc:creator>";
				S = (String)hash.get("keywords");
				result+="<dc:subject>"+S+"</dc:subject>";
				S = (String)hash.get("description");
				result+="<dc:description>"+S+"</dc:description>";
				S = (String)hash.get("D:modificationdate");
				result+="<dc:date>"+S+"</dc:date>";
				S = (String)hash.get("main-language");
				result+="<dc:language>"+S+"</dc:language>";
				S = (String)hash.get("webdavurl");
				//S = webdavpath + S;
				result+="<dc:source>"+S+"</dc:source>";
    		
    	}catch(Exception e)
		{
    		//logger.error("Webdav2oai_dc::createMetadata : "+e.getMessage());
    		
		}
    	
    	result +=  "</"+elementName+">";
    	return result;
    }
}
